/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.Graph2D;
import graph.RTextLine;
import graph.SpecialFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Axis {
    static final int MAX_FRACT_DIGITS = 3;
    static final int MIN_FRACT_DIGITS = 0;
    static final int HORIZONTAL = 0;
    double xLimitMin = 0.0;
    double xLimitMax = 0.0;
    double yLimitMin = 0.0;
    double yLimitMax = 0.0;
    double xTick = 0.0;
    double yTick = 0.0;
    static final int VERTICAL = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    static final int NUMBER_OF_TICS = 4;
    public boolean drawgrid = false;
    public boolean drawzero = false;
    public Color gridcolor = null;
    public Color zerocolor = null;
    public boolean redraw = true;
    public boolean force_end_labels = false;
    public int major_tic_size = 10;
    public int minor_tic_size = 5;
    public int minor_tic_count = 1;
    public Color axiscolor;
    public double minimum = 0.0;
    public double maximum = 0.0;
    public double tick = 0.0;
    public Dimension data_window = new Dimension(0, 0);
    public Graph2D g2d = null;
    protected Point amin;
    protected Point amax;
    protected int orientation;
    protected int position;
    protected int width = 0;
    protected RTextLine title = new RTextLine();
    protected RTextLine label = new RTextLine("0");
    protected RTextLine exponent = new RTextLine();
    protected int max_label_width = 0;
    protected Vector dataset = new Vector();
    protected String[] label_string = null;
    protected float[] label_value = null;
    protected double label_start = 0.0;
    protected double label_step = 0.0;
    protected int label_exponent = 0;
    protected int label_count = 0;
    protected int guess_label_number = 4;
    protected boolean manualRange = false;

    public Axis() {
        this.orientation = 0;
        this.position = 5;
    }

    public Axis(int n) {
        this.setPosition(n);
        switch (this.position) {
            case 1: 
            case 2: {
                this.title.setRotation(90);
                break;
            }
            case 3: {
                this.title.setRotation(-90);
                break;
            }
            default: {
                this.title.setRotation(0);
            }
        }
    }

    private double RoundUp(double d) {
        int n;
        int n2 = (int)Math.floor(SpecialFunction.log10(d));
        if (n2 < 0) {
            n = n2;
            while (n < 0) {
                d *= 10.0;
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                d /= 10.0;
                ++n;
            }
        }
        d = d > 5.0 ? 10.0 : (d > 2.0 ? 5.0 : (d > 1.0 ? 2.0 : 1.0));
        if (n2 < 0) {
            n = n2;
            while (n < 0) {
                d /= 10.0;
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                d *= 10.0;
                ++n;
            }
        }
        return d;
    }

    public void attachDataSet(DataSet dataSet) {
        if (this.orientation == 0) {
            this.attachXdata(dataSet);
        } else {
            this.attachYdata(dataSet);
        }
    }

    protected void attachXdata(DataSet dataSet) {
        this.dataset.addElement(dataSet);
        dataSet.xaxis = this;
        this.minimum = this.xLimitMin;
        this.maximum = this.xLimitMax;
        this.tick = this.xTick;
    }

    protected void attachYdata(DataSet dataSet) {
        this.dataset.addElement(dataSet);
        dataSet.yaxis = this;
        this.minimum = this.yLimitMin;
        this.maximum = this.yLimitMax;
        this.tick = this.yTick;
    }

    protected void calculateGridLabels() {
        this.label_exponent = Math.abs(this.minimum) > Math.abs(this.maximum) ? (int)Math.floor(SpecialFunction.log10(Math.abs(this.minimum)) / 3.0) * 3 : (int)Math.floor(SpecialFunction.log10(Math.abs(this.maximum)) / 3.0) * 3;
        this.label_step = this.tick;
        double d = this.label_start = Math.floor(this.minimum / this.label_step) * this.label_step;
        this.label_count = 1;
        while (d < this.maximum) {
            d += this.label_step;
            ++this.label_count;
        }
        this.label_string = new String[this.label_count];
        this.label_value = new float[this.label_count];
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(0);
        int n = 0;
        while (n < this.label_count) {
            int n2;
            d = this.label_start + (double)n * this.label_step;
            if (this.label_exponent < 0) {
                n2 = this.label_exponent;
                while (n2 < 0) {
                    d *= 10.0;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.label_exponent) {
                    d /= 10.0;
                    ++n2;
                }
            }
            this.label_string[n] = numberFormat.format(d);
            this.label_value[n] = (float)d;
            ++n;
        }
    }

    public void detachAll() {
        if (this.dataset.isEmpty()) {
            return;
        }
        if (this.orientation == 0) {
            int n = 0;
            while (n < this.dataset.size()) {
                DataSet dataSet = (DataSet)this.dataset.elementAt(n);
                dataSet.xaxis = null;
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.dataset.size()) {
                DataSet dataSet = (DataSet)this.dataset.elementAt(n);
                dataSet.yaxis = null;
                ++n;
            }
        }
        this.dataset.removeAllElements();
        this.minimum = 0.0;
        this.maximum = 0.0;
        this.tick = 0.0;
    }

    public void detachDataSet(DataSet dataSet) {
        boolean bl = false;
        if (dataSet == null) {
            return;
        }
        if (this.orientation == 0) {
            dataSet.xaxis = null;
        } else {
            dataSet.yaxis = null;
        }
        this.dataset.removeElement(dataSet);
        if (!this.manualRange) {
            this.resetXRange();
            this.resetYRange();
        }
    }

    public void drawAxis(Graphics graphics) {
        if (!this.redraw) {
            return;
        }
        if (this.minimum == this.maximum) {
            this.maximum = this.minimum + 1.0;
            this.minimum -= 1.0;
        }
        if (this.amin.equals(this.amax)) {
            return;
        }
        if (this.width == 0) {
            this.width = this.getAxisWidth(graphics);
        }
        Graphics graphics2 = graphics.create();
        if (this.force_end_labels) {
            this.minimum = this.label_start;
            this.maximum = this.minimum + (double)(this.label_count - 1) * this.label_step;
        }
        this.title.setDrawingComponent(this.g2d);
        this.label.setDrawingComponent(this.g2d);
        this.exponent.setDrawingComponent(this.g2d);
        if (this.orientation == 0) {
            this.drawHAxis(graphics2);
        } else {
            this.drawVAxis(graphics2);
        }
    }

    protected void drawHAxis(Graphics graphics) {
        int n;
        int n2;
        double d = this.minimum * 1.001;
        double d2 = this.maximum * 1.001;
        double d3 = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            graphics.setColor(this.axiscolor);
        }
        graphics.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        int n3 = this.position == 4 ? 1 : -1;
        double d4 = this.label_step / (double)(this.minor_tic_count + 1);
        double d5 = this.label_start;
        int n4 = 0;
        while (n4 < this.label_count) {
            int n5;
            int n6;
            if (d5 >= d && d5 <= d2) {
                Color color;
                n2 = this.amin.y;
                n = this.amin.x + (int)((d5 - this.minimum) * d3);
                if ((double)Math.abs(this.label_value[n4]) <= 1.0E-4 && this.drawzero) {
                    color = graphics.getColor();
                    if (this.zerocolor != null) {
                        graphics.setColor(this.zerocolor);
                    }
                    graphics.drawLine(n, n2, n, n2 + this.data_window.height * n3);
                    graphics.setColor(color);
                } else if (this.drawgrid) {
                    color = graphics.getColor();
                    if (this.gridcolor != null) {
                        graphics.setColor(this.gridcolor);
                    }
                    graphics.drawLine(n, n2, n, n2 + this.data_window.height * n3);
                    graphics.setColor(color);
                }
                n6 = n;
                n5 = n2 + this.major_tic_size * n3;
                graphics.drawLine(n, n2, n6, n5);
            }
            double d6 = d5 + d4;
            int n7 = 0;
            while (n7 < this.minor_tic_count) {
                if (d6 >= d && d6 <= d2) {
                    n2 = this.amin.y;
                    n6 = n = this.amin.x + (int)((d6 - this.minimum) * d3);
                    n5 = n2 + this.minor_tic_size * n3;
                    graphics.drawLine(n, n2, n6, n5);
                }
                d6 += d4;
                ++n7;
            }
            d5 += this.label_step;
            ++n4;
        }
        int n8 = this.position == 4 ? -this.label.getLeading(graphics) - this.label.getDescent(graphics) : this.label.getLeading(graphics) + this.label.getAscent(graphics);
        d5 = this.label_start;
        n4 = 0;
        while (n4 < this.label_count) {
            if (d5 >= d && d5 <= d2) {
                n2 = this.amin.y + n8;
                n = this.amin.x + (int)((d5 - this.minimum) * d3);
                this.label.setText(this.label_string[n4]);
                this.label.draw(graphics, n, n2, 0);
            }
            d5 += this.label_step;
            ++n4;
        }
        if (!this.exponent.isNull()) {
            n2 = this.position == 4 ? this.amin.y - this.label.getLeading(graphics) - this.label.getDescent(graphics) - this.exponent.getLeading(graphics) - this.exponent.getDescent(graphics) : this.amax.y + this.label.getLeading(graphics) + this.label.getAscent(graphics) + this.exponent.getLeading(graphics) + this.exponent.getAscent(graphics);
            n = this.amax.x;
            this.exponent.draw(graphics, n, n2, 1);
        }
        if (!this.title.isNull()) {
            n2 = this.position == 4 ? this.amin.y - this.label.getLeading(graphics) - this.label.getDescent(graphics) - this.title.getLeading(graphics) - this.title.getDescent(graphics) : this.amax.y + this.label.getLeading(graphics) + this.label.getAscent(graphics) + this.title.getLeading(graphics) + this.title.getAscent(graphics);
            n = this.amin.x + (this.amax.x - this.amin.x) / 2;
            this.title.draw(graphics, n, n2, 0);
        }
    }

    protected void drawVAxis(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        double d = this.minimum * 1.001;
        double d2 = this.maximum * 1.001;
        double d3 = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            graphics.setColor(this.axiscolor);
        }
        graphics.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        int n4 = this.position == 3 ? -1 : 1;
        double d4 = this.label_step / (double)(this.minor_tic_count + 1);
        double d5 = this.label_start;
        int n5 = 0;
        while (n5 < this.label_count) {
            int n6;
            int n7;
            if (d5 >= d && d5 <= d2) {
                Color color2;
                n2 = this.amin.x;
                n = this.amax.y - (int)((d5 - this.minimum) * d3);
                if ((double)Math.abs(this.label_value[n5]) <= 1.0E-4 && this.drawzero) {
                    color2 = graphics.getColor();
                    if (this.zerocolor != null) {
                        graphics.setColor(this.zerocolor);
                    }
                    graphics.drawLine(n2, n, n2 + this.data_window.width * n4, n);
                    graphics.setColor(color2);
                } else if (this.drawgrid) {
                    color2 = graphics.getColor();
                    if (this.gridcolor != null) {
                        graphics.setColor(this.gridcolor);
                    }
                    graphics.drawLine(n2, n, n2 + this.data_window.width * n4, n);
                    graphics.setColor(color2);
                }
                n7 = n2 + this.major_tic_size * n4;
                n6 = n;
                graphics.drawLine(n2, n, n7, n6);
            }
            double d6 = d5 + d4;
            int n8 = 0;
            while (n8 < this.minor_tic_count) {
                if (d6 >= d && d6 <= d2) {
                    n2 = this.amin.x;
                    n = this.amax.y - (int)((d6 - this.minimum) * d3);
                    n7 = n2 + this.minor_tic_size * n4;
                    n6 = n;
                    graphics.drawLine(n2, n, n7, n6);
                }
                d6 += d4;
                ++n8;
            }
            d5 += this.label_step;
            ++n5;
        }
        d5 = this.label_start;
        n5 = 0;
        while (n5 < this.label_count) {
            if (d5 >= d && d5 <= d2) {
                n2 = this.amin.x + n3;
                n = this.amax.y - (int)((d5 - this.minimum) * d3) + this.label.getAscent(graphics) / 2;
                if (this.position == 3) {
                    this.label.setText(" " + this.label_string[n5]);
                    this.label.draw(graphics, n2, n, 1);
                } else {
                    this.label.setText(String.valueOf(this.label_string[n5]) + " ");
                    this.label.draw(graphics, n2, n, 2);
                }
            }
            d5 += this.label_step;
            ++n5;
        }
        if (!this.exponent.isNull()) {
            n = this.amin.y;
            if (this.position == 3) {
                n2 = this.amin.x + this.max_label_width + this.exponent.charWidth(graphics, ' ');
                this.exponent.draw(graphics, n2, n, 1);
            } else {
                n2 = this.amin.x - this.max_label_width - this.exponent.charWidth(graphics, ' ');
                this.exponent.draw(graphics, n2, n, 2);
            }
        }
        if (!this.title.isNull()) {
            n = this.amin.y + (this.amax.y - this.amin.y) / 2;
            if (this.title.getRotation() == 0 || this.title.getRotation() == 180) {
                if (this.position == 3) {
                    n2 = this.amin.x + this.max_label_width + this.title.charWidth(graphics, ' ');
                    this.title.draw(graphics, n2, n, 1);
                } else {
                    n2 = this.amin.x - this.max_label_width - this.title.charWidth(graphics, ' ');
                    this.title.draw(graphics, n2, n, 2);
                }
            } else {
                this.title.setJustification(0);
                n2 = this.position == 3 ? this.amin.x + this.max_label_width - this.title.getLeftEdge(graphics) + this.title.charWidth(graphics, ' ') : this.amin.x - this.max_label_width - this.title.getRightEdge(graphics) - this.title.charWidth(graphics, ' ');
                this.title.draw(graphics, n2, n);
            }
        }
    }

    public int getAxisPos() {
        return this.position;
    }

    public int getAxisWidth(Graphics graphics) {
        this.width = 0;
        if (this.minimum == this.maximum) {
            return 0;
        }
        if (this.dataset.size() == 0) {
            return 0;
        }
        this.calculateGridLabels();
        this.exponent.setText(null);
        if (this.label_exponent != 0) {
            this.exponent.copyState(this.label);
            this.exponent.setText("x10^" + String.valueOf(this.label_exponent));
        }
        if (this.orientation == 0) {
            this.width = this.label.getRHeight(graphics) + this.label.getLeading(graphics);
            this.width += Math.max(this.title.getRHeight(graphics), this.exponent.getRHeight(graphics));
        } else {
            int n = 0;
            while (n < this.label_string.length) {
                this.label.setText(" " + this.label_string[n]);
                this.width = Math.max(this.label.getRWidth(graphics), this.width);
                ++n;
            }
            this.max_label_width = this.width;
            this.width = 0;
            if (!this.title.isNull()) {
                this.width = Math.max(this.width, this.title.getRWidth(graphics) + this.title.charWidth(graphics, ' '));
            }
            if (!this.exponent.isNull()) {
                this.width = Math.max(this.width, this.exponent.getRWidth(graphics) + this.exponent.charWidth(graphics, ' '));
            }
            this.width += this.max_label_width;
        }
        return this.width;
    }

    public double getDataMax() {
        double d;
        if (this.dataset.isEmpty()) {
            return 0.0;
        }
        DataSet dataSet = (DataSet)this.dataset.firstElement();
        if (dataSet == null) {
            return 0.0;
        }
        if (this.orientation == 0) {
            d = dataSet.getXmax();
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                dataSet = (DataSet)enumeration.nextElement();
                d = Math.max(dataSet.getXmax(), d);
            }
        } else {
            d = dataSet.getYmax();
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                dataSet = (DataSet)enumeration.nextElement();
                d = Math.max(dataSet.getYmax(), d);
            }
        }
        return d;
    }

    public double getDataMin() {
        double d;
        if (this.dataset.isEmpty()) {
            return 0.0;
        }
        DataSet dataSet = (DataSet)this.dataset.firstElement();
        if (dataSet == null) {
            return 0.0;
        }
        if (this.orientation == 0) {
            d = dataSet.getXmin();
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                dataSet = (DataSet)enumeration.nextElement();
                d = Math.min(dataSet.getXmin(), d);
            }
        } else {
            d = dataSet.getYmin();
            Enumeration enumeration = this.dataset.elements();
            while (enumeration.hasMoreElements()) {
                dataSet = (DataSet)enumeration.nextElement();
                d = Math.min(dataSet.getYmin(), d);
            }
        }
        return d;
    }

    public double getDouble(int n) {
        if (this.orientation == 0) {
            double d = (this.maximum - this.minimum) / (double)(this.amax.x - this.amin.x);
            return this.minimum + (double)(n - this.amin.x) * d;
        }
        double d = (this.maximum - this.minimum) / (double)(this.amax.y - this.amin.y);
        return this.maximum - (double)(n - this.amin.y) * d;
    }

    public int getInteger(double d) {
        if (this.orientation == 0) {
            double d2 = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
            return this.amin.x + (int)((d - this.minimum) * d2);
        }
        double d3 = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        return this.amin.y + (int)((this.maximum - d) * d3);
    }

    public double getXMax() {
        return this.xLimitMax;
    }

    public double getXMin() {
        return this.xLimitMin;
    }

    public double getXTic() {
        return this.xTick;
    }

    public double getYMax() {
        return this.yLimitMax;
    }

    public double getYMin() {
        return this.yLimitMin;
    }

    public double getYTic() {
        return this.yTick;
    }

    public boolean isVertical() {
        return this.orientation != 0;
    }

    public boolean positionAxis(int n, int n2, int n3, int n4) {
        this.amin = null;
        this.amax = null;
        if (this.orientation == 0 && n3 != n4) {
            return false;
        }
        if (this.orientation == 1 && n != n2) {
            return false;
        }
        this.amin = new Point(n, n3);
        this.amax = new Point(n2, n4);
        return true;
    }

    public void resetXRange() {
        this.minimum = this.getXMin();
        this.maximum = this.getXMax();
        this.tick = this.getXTic();
    }

    public void resetYRange() {
        this.minimum = this.getYMin();
        this.maximum = this.getYMax();
        this.tick = this.getYTic();
    }

    public void setExponentColor(Color color) {
        this.exponent.setColor(color);
    }

    public void setExponentFont(Font font) {
        this.exponent.setFont(font);
    }

    public void setLabelColor(Color color) {
        this.label.setColor(color);
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
    }

    public void setManualRange(boolean bl) {
        this.manualRange = bl;
    }

    public void setPosition(int n) {
        this.position = n;
        switch (this.position) {
            case 2: {
                this.orientation = 1;
                break;
            }
            case 3: {
                this.orientation = 1;
                break;
            }
            case 4: {
                this.orientation = 0;
                break;
            }
            case 5: {
                this.orientation = 0;
                break;
            }
            case 0: {
                this.orientation = 0;
                this.position = 5;
                break;
            }
            case 1: {
                this.orientation = 1;
                this.position = 2;
                break;
            }
            default: {
                this.orientation = 0;
                this.position = 5;
            }
        }
    }

    public void setTitleColor(Color color) {
        this.title.setColor(color);
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    public void setTitleRotation(int n) {
        this.title.setRotation(n);
    }

    public void setTitleText(String string) {
        this.title.setText(string);
    }

    public void setXMax(double d) {
        this.xLimitMax = d;
        this.resetXRange();
    }

    public void setXMin(double d) {
        this.xLimitMin = d;
        this.resetXRange();
    }

    public void setXTic(double d) {
        this.xTick = d;
        this.resetXRange();
    }

    public void setYMax(double d) {
        this.yLimitMax = d;
        this.resetYRange();
    }

    public void setYMin(double d) {
        this.yLimitMin = d;
        this.resetYRange();
    }

    public void setYTic(double d) {
        this.yTick = d;
        this.resetYRange();
    }
}

