/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.Contour;
import graph.DataSet;
import graph.G2Dint;
import graph.Graph2D;
import graph.Markers;
import graph.NamedObject;
import graph.ParseFunction;
import graph.RTextLine;
import graph.ScanWord;
import graph.TextLine;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.io.Reader;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public class BuildGraph
extends ScanWord {
    static final int BEGIN = 256;
    static final int GRAPH2D = 257;
    static final int MARKER = 258;
    static final int AXIS = 259;
    static final int URL = 260;
    static final int DATA = 261;
    static final int SIZE = 262;
    static final int COLOR = 263;
    static final int NAME = 264;
    static final int TITLE = 265;
    static final int LABEL = 266;
    static final int FONT = 267;
    static final int STYLE = 268;
    static final int BOTTOM = 269;
    static final int TOP = 270;
    static final int LEFT = 271;
    static final int RIGHT = 272;
    static final int END = 273;
    static final int G2DINT = 274;
    static final int OFF = 275;
    static final int ON = 276;
    static final int ATTACH = 277;
    static final int PLAIN = 278;
    static final int BOLD = 279;
    static final int ITALIC = 280;
    static final int DEBUG = 281;
    static final int GRID = 282;
    static final int ZERO = 283;
    static final int CONTOUR = 284;
    static final int LLEVELS = 285;
    static final int NUMBER = 286;
    static final int CDATA = 287;
    static final int FUNCTION = 288;
    static final int XRANGE = 289;
    static final int YRANGE = 290;
    static final int BACKGROUND = 291;
    static final int LOGCONTOURS = 292;
    static final int CLABELS = 293;
    static final int SQUARE = 294;
    static final int MARKER_STYLE = 512;
    static final int MARKER_COLOR = 513;
    static final int MARKER_SIZE = 514;
    static final int LABEL_COLOR = 515;
    static final int LABEL_FONT = 517;
    static final int GRID_COLOR = 520;
    static final int GRID_OFF = 521;
    static final int ZERO_COLOR = 522;
    static final int ZERO_OFF = 523;
    static final int MARKER_URL = 524;
    static final int GRID_ON = 525;
    static final int ZERO_ON = 526;
    static final int XMIN = 527;
    static final int XMAX = 528;
    static final int YMIN = 529;
    static final int YMAX = 530;
    static final int XNUMBER = 531;
    static final int YNUMBER = 532;
    static final int LABEL_OFF = 533;
    protected Stack build = new Stack();
    protected Stack object = new Stack();
    protected Vector built = new Vector();
    protected Object graph = null;
    protected TextLine graphtitle = null;
    protected Applet applet;
    protected boolean debug = false;
    private Vector datasets = new Vector();
    public int lineno = 1;
    public int level = 0;

    public BuildGraph(Reader reader, Applet applet) {
        super(reader);
        this.applet = applet;
        this.addKeyWord("{", 256);
        this.addKeyWord("}", 273);
        this.addKeyWord("graph2d", 257);
        this.addKeyWord("g2dint", 274);
        this.addKeyWord("marker", 258);
        this.addKeyWord("axis", 259);
        this.addKeyWord("url", 260);
        this.addKeyWord("data", 261);
        this.addKeyWord("size", 262);
        this.addKeyWord("color", 263);
        this.addKeyWord("name", 264);
        this.addKeyWord("title", 265);
        this.addKeyWord("label", 266);
        this.addKeyWord("font", 267);
        this.addKeyWord("style", 268);
        this.addKeyWord("bottom", 269);
        this.addKeyWord("top", 270);
        this.addKeyWord("left", 271);
        this.addKeyWord("right", 272);
        this.addKeyWord("on", 276);
        this.addKeyWord("off", 275);
        this.addKeyWord("attach", 277);
        this.addKeyWord("plain", 278);
        this.addKeyWord("bold", 279);
        this.addKeyWord("italic", 280);
        this.addKeyWord("debug", 281);
        this.addKeyWord("grid", 282);
        this.addKeyWord("zero", 283);
        this.addKeyWord("contour", 284);
        this.addKeyWord("number", 286);
        this.addKeyWord("cdata", 287);
        this.addKeyWord("function", 288);
        this.addKeyWord("xrange", 289);
        this.addKeyWord("yrange", 290);
        this.addKeyWord("background", 291);
        this.addKeyWord("llevels", 285);
        this.addKeyWord("square", 294);
        this.addKeyWord("log", 292);
    }

    protected double[] arrayFromFunction(ParseFunction parseFunction, int n, double d, double d2) {
        double[] dArray = new double[2 * n];
        double d3 = (d2 - d) / (double)(n - 1);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d4 = d + (double)n3 * d3;
            try {
                double d5 = parseFunction.getResult(d4);
                dArray[n2++] = d4;
                dArray[n2++] = d5;
            }
            catch (Exception exception) {}
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        return dArray;
    }

    protected double[] arrayFromFunction(ParseFunction parseFunction, int n, double d, double d2, int n2, double d3, double d4) {
        double[] dArray = new double[n2 * n];
        double d5 = (d2 - d) / (double)(n - 1);
        double d6 = (d4 - d3) / (double)(n2 - 1);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            double d7 = d3 + (double)n4 * d6;
            int n5 = 0;
            while (n5 < n) {
                double d8 = d + (double)n5 * d5;
                try {
                    dArray[n3++] = parseFunction.getResult(d8, d7);
                }
                catch (Exception exception) {
                    dArray[n3++] = 0.0;
                }
                ++n5;
            }
            ++n4;
        }
        if (n3 == 0) {
            return null;
        }
        return dArray;
    }

    protected boolean build(NamedObject namedObject) {
        switch (namedObject.id) {
            case 267: {
                return this.buildFont();
            }
            case 258: {
                return this.buildMarker();
            }
            case 265: {
                return this.buildTitle();
            }
            case 266: {
                return this.buildLabel();
            }
            case 261: 
            case 287: {
                return this.buildData(namedObject.id);
            }
            case 259: {
                return this.buildAxis();
            }
            case 282: {
                return this.buildGrid();
            }
            case 283: {
                return this.buildZero();
            }
            case 257: 
            case 274: 
            case 284: {
                return this.buildGraph(namedObject.id);
            }
        }
        this.errorAtLine("Incorrect keyword followed by braces");
        return false;
    }

    protected boolean buildAxis() {
        Stack<NamedObject> stack = new Stack<NamedObject>();
        Axis axis = new Axis();
        NamedObject namedObject = new NamedObject((Object)axis, 259);
        int n = 0;
        block12: while (true) {
            NamedObject namedObject2 = (NamedObject)this.object.pop();
            this.debugMessage("Axis", namedObject2.id);
            switch (namedObject2.id) {
                case 264: {
                    namedObject.setName((String)namedObject2.getObject());
                    continue block12;
                }
                case 265: {
                    axis.title = (RTextLine)namedObject2.getObject();
                    continue block12;
                }
                case 517: {
                    axis.label.setFont((Font)namedObject2.getObject());
                    continue block12;
                }
                case 515: {
                    axis.label.setColor((Color)namedObject2.getObject());
                    continue block12;
                }
                case 269: {
                    axis.setPosition(5);
                    continue block12;
                }
                case 270: {
                    axis.setPosition(4);
                    continue block12;
                }
                case 271: {
                    axis.setPosition(2);
                    n = 90;
                    continue block12;
                }
                case 272: {
                    axis.setPosition(3);
                    n = -90;
                    continue block12;
                }
                case 277: {
                    stack.push(new NamedObject(axis, (String)namedObject2.getObject(), 277));
                    continue block12;
                }
                case 256: {
                    axis.g2d = (Graph2D)this.graph;
                    axis.setTitleRotation(n);
                    this.object.push(namedObject);
                    while (stack.size() > 0) {
                        this.object.push(stack.pop());
                    }
                    this.built.addElement(axis);
                    this.applet.showStatus("BuildGraph: Built Axis!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Data specification");
        return false;
    }

    protected boolean buildContour(NamedObject namedObject) {
        switch (namedObject.id) {
            case 286: {
                ((Contour)this.graph).setNLevels((Integer)namedObject.getObject());
                break;
            }
            case 285: {
                ((Contour)this.graph).setLabelLevels((Integer)namedObject.getObject());
                break;
            }
            case 263: {
                ((Contour)this.graph).setContourColor((Color)namedObject.getObject());
                break;
            }
            case 292: {
                ((Contour)this.graph).logLevels = true;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean buildData(int n) {
        DataSet dataSet = new DataSet();
        NamedObject namedObject = new NamedObject((Object)dataSet, 261);
        ParseFunction parseFunction = null;
        Object e = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        if (n == 287 && !(this.graph instanceof Contour)) {
            this.errorAtLine("CDATA can only be used in CONTOUR!");
        }
        block20: while (true) {
            NamedObject namedObject2 = (NamedObject)this.object.pop();
            this.debugMessage("Data", namedObject2.id);
            switch (namedObject2.id) {
                case 260: {
                    continue block20;
                }
                case 264: {
                    namedObject.setName((String)namedObject2.getObject());
                    continue block20;
                }
                case 512: {
                    dataSet.marker = (Integer)namedObject2.getObject();
                    continue block20;
                }
                case 514: {
                    dataSet.markerscale = ((Integer)namedObject2.getObject()).intValue();
                    continue block20;
                }
                case 513: {
                    dataSet.markercolor = (Color)namedObject2.getObject();
                    continue block20;
                }
                case 275: {
                    dataSet.linestyle = 0;
                    continue block20;
                }
                case 276: {
                    dataSet.linestyle = 1;
                    continue block20;
                }
                case 263: {
                    if (n == 287) {
                        ((Contour)this.graph).setContourColor((Color)namedObject2.getObject());
                        continue block20;
                    }
                    dataSet.linecolor = (Color)namedObject2.getObject();
                    continue block20;
                }
                case 288: {
                    parseFunction = new ParseFunction((String)namedObject2.getObject());
                    if (parseFunction.parse()) continue block20;
                    this.errorAtLine("Error in function definition!");
                    return false;
                }
                case 531: {
                    n2 = (Integer)namedObject2.getObject();
                    continue block20;
                }
                case 527: {
                    d = (Double)namedObject2.getObject();
                    continue block20;
                }
                case 528: {
                    d2 = (Double)namedObject2.getObject();
                    continue block20;
                }
                case 532: {
                    n3 = (Integer)namedObject2.getObject();
                    continue block20;
                }
                case 529: {
                    d3 = (Double)namedObject2.getObject();
                    continue block20;
                }
                case 530: {
                    d4 = (Double)namedObject2.getObject();
                    continue block20;
                }
                case 256: {
                    if (parseFunction != null && n == 287) {
                        if (!(this.graph instanceof Contour)) {
                            this.errorAtLine("CDATA should only be used for Contours!");
                            return false;
                        }
                        double[] dArray = this.arrayFromFunction(parseFunction, n2, d, d2, n3, d3, d4);
                        if (dArray == null) {
                            this.errorAtLine("Unable to build Data from Function");
                            return false;
                        }
                        ((Contour)this.graph).setRange(d, d2, d3, d4);
                        ((Contour)this.graph).setGrid(dArray, n2, n3);
                        return true;
                    }
                    if (parseFunction != null) {
                        double[] dArray = this.arrayFromFunction(parseFunction, n2, d, d2);
                        if (dArray == null) {
                            this.errorAtLine("Unable to build Data from Function");
                            return false;
                        }
                        try {
                            dataSet.append(dArray, n2);
                            this.object.push(namedObject);
                            this.datasets.addElement(namedObject);
                            this.built.addElement(dataSet);
                            return true;
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    if (e == null) {
                        this.errorAtLine("No URL has been defined for Data!");
                        return false;
                    }
                    this.object.push(namedObject);
                    this.built.addElement(dataSet);
                    this.built.addElement(e);
                    this.datasets.addElement(namedObject);
                    this.applet.showStatus("BuildGraph: Loading Data!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Data specification");
        return false;
    }

    protected boolean buildFont() {
        String string = "TimesRoman";
        int n = 0;
        int n2 = 20;
        block10: while (true) {
            NamedObject namedObject = (NamedObject)this.object.pop();
            this.debugMessage("Font", namedObject.id);
            switch (namedObject.id) {
                case 264: {
                    string = (String)namedObject.getObject();
                    continue block10;
                }
                case 262: {
                    n2 = (Integer)namedObject.getObject();
                    continue block10;
                }
                case 278: {
                    n += 0;
                    continue block10;
                }
                case 279: {
                    ++n;
                    continue block10;
                }
                case 280: {
                    n += 2;
                    continue block10;
                }
                case 256: {
                    try {
                        Font font = new Font(string, n, n2);
                        namedObject = new NamedObject((Object)font, 267);
                        this.object.push(namedObject);
                        this.applet.showStatus("BuildGraph: Built Font!");
                        return true;
                    }
                    catch (Exception exception) {
                        this.errorAtLine("Ill formed font specification");
                        return false;
                    }
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Font specification");
        return false;
    }

    protected boolean buildGraph(int n) {
        NamedObject namedObject;
        String string = n == 284 ? "Contour" : (n == 274 ? "G2Dint" : "Graph");
        block19: while (true) {
            namedObject = (NamedObject)this.object.pop();
            this.debugMessage(string, namedObject.id);
            switch (namedObject.id) {
                case 259: {
                    Axis axis = (Axis)namedObject.getObject();
                    if (n == 257) {
                        ((Graph2D)this.graph).attachAxis(axis);
                        continue block19;
                    }
                    ((G2Dint)this.graph).attachAxis(axis);
                    continue block19;
                }
                case 261: {
                    ((Graph2D)this.graph).attachDataSet((DataSet)namedObject.getObject());
                    continue block19;
                }
                case 277: {
                    Axis axis = (Axis)namedObject.getObject();
                    String string2 = namedObject.getName();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < this.datasets.size()) {
                        namedObject = (NamedObject)this.datasets.elementAt(n2);
                        if (string2.equals(namedObject.getName())) {
                            axis.attachDataSet((DataSet)namedObject.getObject());
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) continue block19;
                    this.errorAtLine("Data name not found for Attach keyword");
                    continue block19;
                }
                case 520: {
                    ((Graph2D)this.graph).gridcolor = (Color)namedObject.getObject();
                    continue block19;
                }
                case 521: {
                    ((Graph2D)this.graph).drawgrid = false;
                    continue block19;
                }
                case 525: {
                    ((Graph2D)this.graph).drawgrid = true;
                    continue block19;
                }
                case 522: {
                    ((Graph2D)this.graph).zerocolor = (Color)namedObject.getObject();
                    continue block19;
                }
                case 523: {
                    ((Graph2D)this.graph).drawzero = false;
                    continue block19;
                }
                case 526: {
                    ((Graph2D)this.graph).drawzero = true;
                    continue block19;
                }
                case 258: {
                    ((Graph2D)this.graph).setMarkers((Markers)namedObject.getObject());
                    continue block19;
                }
                case 265: {
                    this.graphtitle = (TextLine)namedObject.getObject();
                    this.built.addElement(this.graphtitle);
                    continue block19;
                }
                case 271: {
                    ((Graph2D)this.graph).borderLeft = (Integer)namedObject.getObject();
                    continue block19;
                }
                case 272: {
                    ((Graph2D)this.graph).borderRight = (Integer)namedObject.getObject();
                    continue block19;
                }
                case 270: {
                    ((Graph2D)this.graph).borderTop = (Integer)namedObject.getObject();
                    continue block19;
                }
                case 269: {
                    ((Graph2D)this.graph).borderBottom = (Integer)namedObject.getObject();
                    continue block19;
                }
                case 294: {
                    ((Graph2D)this.graph).square = true;
                    continue block19;
                }
                case 256: {
                    this.built.addElement(this.graph);
                    this.applet.showStatus("BuildGraph: Built Graph!!!");
                    return true;
                }
            }
            break;
        }
        if (n == 284) {
            if (!this.buildContour(namedObject)) {
                this.errorAtLine("Incorrect keyword in Contour specification");
                return false;
            }
            return true;
        }
        this.errorAtLine("Incorrect keyword in Graph specification");
        return false;
    }

    protected boolean buildGrid() {
        NamedObject namedObject = null;
        NamedObject namedObject2 = null;
        block6: while (true) {
            NamedObject namedObject3 = (NamedObject)this.object.pop();
            this.debugMessage("Grid", namedObject3.id);
            switch (namedObject3.id) {
                case 275: {
                    namedObject2 = namedObject3;
                    namedObject2.setId(521);
                    continue block6;
                }
                case 276: {
                    namedObject2 = namedObject3;
                    namedObject2.setId(525);
                    continue block6;
                }
                case 263: {
                    namedObject = namedObject3;
                    namedObject.setId(520);
                    continue block6;
                }
                case 256: {
                    if (namedObject2 != null) {
                        this.object.push(namedObject2);
                    }
                    if (namedObject != null) {
                        this.object.push(namedObject);
                    }
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Grid specification");
        return false;
    }

    protected boolean buildLabel() {
        NamedObject namedObject = null;
        NamedObject namedObject2 = null;
        block5: while (true) {
            NamedObject namedObject3 = (NamedObject)this.object.pop();
            this.debugMessage("Label", namedObject3.id);
            switch (namedObject3.id) {
                case 267: {
                    namedObject2 = namedObject3;
                    namedObject2.setId(517);
                    continue block5;
                }
                case 263: {
                    namedObject = namedObject3;
                    namedObject.setId(515);
                    continue block5;
                }
                case 256: {
                    if (namedObject != null) {
                        this.object.push(namedObject);
                    }
                    if (namedObject2 != null) {
                        this.object.push(namedObject2);
                    }
                    this.applet.showStatus("BuildGraph: Built Axis Label!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Label specification");
        return false;
    }

    protected boolean buildMarker() {
        Markers markers = null;
        NamedObject namedObject = null;
        NamedObject namedObject2 = null;
        NamedObject namedObject3 = null;
        block9: while (true) {
            NamedObject namedObject4 = (NamedObject)this.object.pop();
            this.debugMessage("Marker", namedObject4.id);
            switch (namedObject4.id) {
                case 262: {
                    namedObject = namedObject4;
                    namedObject.setId(514);
                    continue block9;
                }
                case 263: {
                    namedObject2 = namedObject4;
                    namedObject2.setId(513);
                    continue block9;
                }
                case 268: {
                    namedObject3 = namedObject4;
                    if (namedObject3.getObject() instanceof Integer) {
                        namedObject3.setId(512);
                        continue block9;
                    }
                    this.errorAtLine("Style should be an Integer in MARKER");
                    return false;
                }
                case 260: {
                    try {
                        markers = new Markers((URL)namedObject4.getObject());
                    }
                    catch (Exception exception) {
                        this.errorAtLine("Failed to load markers: " + exception.getMessage());
                    }
                    continue block9;
                }
                case 256: {
                    if (markers != null) {
                        namedObject4 = new NamedObject(markers, 258);
                        this.object.push(namedObject4);
                        this.built.addElement(markers);
                        this.applet.showStatus("BuildGraph: Loaded Marker file!");
                        return true;
                    }
                    if (namedObject2 != null) {
                        this.object.push(namedObject2);
                    }
                    if (namedObject != null) {
                        this.object.push(namedObject);
                    }
                    if (namedObject3 != null) {
                        this.object.push(namedObject3);
                    }
                    this.applet.showStatus("BuildGraph: Built Marker!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in MARKER specification");
        return false;
    }

    protected boolean buildTitle() {
        RTextLine rTextLine = new RTextLine();
        block6: while (true) {
            NamedObject namedObject = (NamedObject)this.object.pop();
            this.debugMessage("Title", namedObject.id);
            switch (namedObject.id) {
                case 264: {
                    rTextLine.setText((String)namedObject.getObject());
                    continue block6;
                }
                case 267: {
                    rTextLine.setFont((Font)namedObject.getObject());
                    continue block6;
                }
                case 263: {
                    rTextLine.setColor((Color)namedObject.getObject());
                    continue block6;
                }
                case 256: {
                    namedObject = new NamedObject((Object)rTextLine, 265);
                    this.object.push(namedObject);
                    this.applet.showStatus("BuildGraph: Built Title!");
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Title specification");
        return false;
    }

    protected boolean buildZero() {
        NamedObject namedObject = null;
        NamedObject namedObject2 = null;
        block6: while (true) {
            NamedObject namedObject3 = (NamedObject)this.object.pop();
            this.debugMessage("Zero", namedObject3.id);
            switch (namedObject3.id) {
                case 275: {
                    namedObject2 = namedObject3;
                    namedObject2.setId(523);
                    continue block6;
                }
                case 276: {
                    namedObject2 = namedObject3;
                    namedObject2.setId(526);
                    continue block6;
                }
                case 263: {
                    namedObject = namedObject3;
                    namedObject.setId(522);
                    continue block6;
                }
                case 256: {
                    if (namedObject2 != null) {
                        this.object.push(namedObject2);
                    }
                    if (namedObject != null) {
                        this.object.push(namedObject);
                    }
                    return true;
                }
            }
            break;
        }
        this.errorAtLine("Incorrect keyword in Zero specification");
        return false;
    }

    private void debugMessage(String string, int n) {
        String string2 = null;
        if (!this.debug) {
            return;
        }
        switch (n) {
            case 281: {
                string2 = null;
                break;
            }
            case 274: {
                string2 = "G2DINT";
                break;
            }
            case 257: {
                string2 = "GRAPH2D";
                break;
            }
            case 284: {
                string2 = "CONTOUR";
                break;
            }
            case -1: {
                string2 = null;
                break;
            }
            case 10: {
                string2 = null;
                break;
            }
            case 260: {
                string2 = "URL";
                break;
            }
            case 277: {
                string2 = "ATTACH";
                break;
            }
            case 268: {
                string2 = "STYLE";
                break;
            }
            case 262: {
                string2 = "SIZE";
                break;
            }
            case 263: {
                string2 = "COLOR";
                break;
            }
            case 264: {
                string2 = "NAME";
                break;
            }
            case 256: {
                string2 = "BEGIN";
                break;
            }
            case 273: {
                string2 = "END";
                break;
            }
            case 258: {
                string2 = "MARKER";
                break;
            }
            case 259: {
                string2 = "AXIS";
                break;
            }
            case 265: {
                string2 = "TITLE";
                break;
            }
            case 261: {
                string2 = "DATA";
                break;
            }
            case 266: {
                string2 = "LABEL";
                break;
            }
            case 267: {
                string2 = "FONT";
                break;
            }
            case 269: {
                string2 = "BOTTOM";
                break;
            }
            case 270: {
                string2 = "TOP";
                break;
            }
            case 271: {
                string2 = "LEFT";
                break;
            }
            case 272: {
                string2 = "RIGHT";
                break;
            }
            case 276: {
                string2 = "ON";
                break;
            }
            case 275: {
                string2 = "OFF";
                break;
            }
            case 278: {
                string2 = "PLAIN";
                break;
            }
            case 279: {
                string2 = "BOLD";
                break;
            }
            case 280: {
                string2 = "ITALIC";
                break;
            }
            case 512: {
                string2 = "MARKER_STYLE";
                break;
            }
            case 513: {
                string2 = "MARKER_COLOR";
                break;
            }
            case 514: {
                string2 = "MARKER_SIZE";
                break;
            }
            case 515: {
                string2 = "LABEL_COLOR";
                break;
            }
            case 517: {
                string2 = "LABEL_FONT";
                break;
            }
            case 520: {
                string2 = "GRID_COLOR";
                break;
            }
            case 282: {
                string2 = "GRID";
                break;
            }
            case 521: {
                string2 = "GRID_OFF";
                break;
            }
            case 525: {
                string2 = "GRID_ON";
                break;
            }
            case 522: {
                string2 = "ZERO_COLOR";
                break;
            }
            case 283: {
                string2 = "ZERO";
                break;
            }
            case 523: {
                string2 = "ZERO_OFF";
                break;
            }
            case 526: {
                string2 = "ZERO_ON";
                break;
            }
            case 524: {
                string2 = "MARKER_URL";
                break;
            }
            case 288: {
                string2 = "FUNCTION";
                break;
            }
            case 289: {
                string2 = "XRANGE";
                break;
            }
            case 290: {
                string2 = "YRANGE";
                break;
            }
            case 286: {
                string2 = "NUMBER";
                break;
            }
            case 294: {
                string2 = "SQUARE";
                break;
            }
            case 291: {
                string2 = "BACKGROUND";
                break;
            }
            default: {
                string2 = "UNKNOWN";
            }
        }
    }

    private void errorAtLine(String string) {
        this.applet.showStatus("Error at line " + this.lineno + ": " + string);
    }

    public Vector getBuilt() {
        return this.built;
    }

    public Object getGraph() {
        return this.graph;
    }

    public TextLine getGraphTitle() {
        return this.graphtitle;
    }

    protected boolean isContext(int n) {
        int n2 = 0;
        while (n2 < this.build.size()) {
            if (((NamedObject)this.build.elementAt((int)n2)).id == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void parse() {
        boolean bl = true;
        block24: while (bl) {
            int n = this.nextWord();
            this.debugMessage("Main", n);
            switch (n) {
                case 281: {
                    this.debug ^= true;
                    break;
                }
                case 284: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new Contour();
                    NamedObject namedObject = new NamedObject(this.graph, 284);
                    this.object.push(namedObject);
                    break;
                }
                case 274: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new G2Dint();
                    NamedObject namedObject = new NamedObject(this.graph, 274);
                    this.object.push(namedObject);
                    break;
                }
                case 257: {
                    if (this.graph != null) {
                        this.errorAtLine("Graph already defined.");
                        return;
                    }
                    this.graph = new Graph2D();
                    NamedObject namedObject = new NamedObject(this.graph, 257);
                    this.object.push(namedObject);
                    break;
                }
                case -1: {
                    bl = false;
                    break;
                }
                case 10: {
                    ++this.lineno;
                    if (this.lineno != this.lineno / 10 * 10) continue block24;
                    this.applet.showStatus("Reading input: Line " + this.lineno);
                    break;
                }
                case 269: 
                case 270: 
                case 271: 
                case 272: {
                    int n2;
                    NamedObject namedObject;
                    if (this.isContext(259)) {
                        namedObject = new NamedObject(n);
                    } else {
                        n2 = this.nextWord();
                        if (n2 == -2) {
                            namedObject = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), n);
                        } else {
                            this.errorAtLine("In this context LEFT, RIGHT, TOP or BOTTOM should be followed an integer");
                            return;
                        }
                    }
                    this.object.push(namedObject);
                    break;
                }
                case 260: {
                    NamedObject namedObject;
                    n = this.nextWord();
                    if (n == -258) {
                        try {
                            URL uRL = new URL(this.applet.getDocumentBase(), this.sval);
                            namedObject = new NamedObject((Object)uRL, 260);
                        }
                        catch (Exception exception) {
                            this.errorAtLine("Failed to build URL!");
                            return;
                        }
                    } else {
                        this.errorAtLine("URL should be followed by a string");
                        return;
                    }
                    this.object.push(namedObject);
                    break;
                }
                case 277: {
                    if (!this.isContext(259)) {
                        this.errorAtLine("ATTACH should only appear in AXIS context");
                        return;
                    }
                    n = this.nextWord();
                    if (n != -258) {
                        this.errorAtLine("ATTACH should be followed by a string");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)this.sval, 277);
                    this.object.push(namedObject);
                    break;
                }
                case 268: {
                    NamedObject namedObject;
                    if (!this.isContext(258) && !this.isContext(267)) {
                        this.errorAtLine("STYLE should only appear in MARKER or FONT context");
                        return;
                    }
                    n = this.nextWord();
                    if (n == 278) {
                        namedObject = new NamedObject(278);
                    } else if (n == 279) {
                        namedObject = new NamedObject(279);
                    } else if (n == 280) {
                        namedObject = new NamedObject(278);
                    } else if (n == -2) {
                        namedObject = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 268);
                    } else {
                        this.errorAtLine("STYLE should be followed an integer or Keyword");
                        return;
                    }
                    this.object.push(namedObject);
                    break;
                }
                case 262: {
                    if (!this.isContext(258) && !this.isContext(267)) {
                        this.errorAtLine("SIZE should only appear in MARKER or FONT context");
                        return;
                    }
                    n = this.nextWord();
                    if (n != -2) {
                        this.errorAtLine("SIZE should be followed by an integer");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 262);
                    this.object.push(namedObject);
                    break;
                }
                case 285: {
                    if (!this.isContext(284)) {
                        this.errorAtLine("LLEVELS should only appear in CONTOUR context");
                        return;
                    }
                    n = this.nextWord();
                    if (n != -2) {
                        this.errorAtLine("LLEVELS should be followed by an integer");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 285);
                    this.object.push(namedObject);
                    break;
                }
                case 263: 
                case 291: {
                    int n3;
                    NamedObject namedObject;
                    int[] nArray = new int[]{-1, -1, -1};
                    int n2 = 0;
                    while (n2 < 3) {
                        n3 = this.nextWord();
                        if (n3 != -2 || this.nval < 0.0 || this.nval > 255.0) {
                            this.errorAtLine("Incorrect Color definition");
                            return;
                        }
                        nArray[n2] = (int)(this.nval + 0.001);
                        ++n2;
                    }
                    if (n == 263) {
                        namedObject = new NamedObject((Object)new Color(nArray[0], nArray[1], nArray[2]), 263);
                        this.object.push(namedObject);
                        break;
                    }
                    if (this.isContext(261) || this.isContext(287)) {
                        ((Graph2D)this.graph).setDataBackground(new Color(nArray[0], nArray[1], nArray[2]));
                        break;
                    }
                    ((Graph2D)this.graph).setGraphBackground(new Color(nArray[0], nArray[1], nArray[2]));
                    break;
                }
                case 264: {
                    n = this.nextWord();
                    if (n != -258) {
                        this.errorAtLine("NAME should be followed by a string");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)this.sval, 264);
                    this.object.push(namedObject);
                    break;
                }
                case 288: {
                    n = this.nextWord();
                    if (n != -258) {
                        this.errorAtLine("FUNCTION should be followed by a string");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)this.sval, 288);
                    this.object.push(namedObject);
                    break;
                }
                case 286: {
                    n = this.nextWord();
                    if (n != -2) {
                        this.errorAtLine("NUMBER should be followed by an integer");
                        return;
                    }
                    NamedObject namedObject = new NamedObject((Object)new Integer((int)(this.nval + 0.01)), 286);
                    this.object.push(namedObject);
                    break;
                }
                case 289: 
                case 290: {
                    NamedObject namedObject;
                    int n3 = 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    int n4 = 0;
                    int n5 = this.nextWord();
                    if (n5 == -2) {
                        n4 = (int)(this.nval + 0.001);
                        n5 = this.nextWord();
                        if (n5 == -2) {
                            d = this.nval;
                            n5 = this.nextWord();
                            if (n5 == -2) {
                                d2 = this.nval;
                            } else {
                                n3 = 1;
                            }
                        } else {
                            n3 = 1;
                        }
                    } else {
                        n3 = 1;
                    }
                    if (n3 != 0) {
                        this.errorAtLine("Range limits must be followed by 3 numbers");
                        return;
                    }
                    if (d == d2) {
                        this.errorAtLine("Range limits must not be the same");
                        return;
                    }
                    if (n4 <= 1) {
                        this.errorAtLine("Number of points must be greater than 1");
                        return;
                    }
                    if (d > d2) {
                        double d3 = d2;
                        d2 = d;
                        d = d3;
                    }
                    if (n == 289) {
                        namedObject = new NamedObject((Object)new Integer(n4), 531);
                        this.object.push(namedObject);
                        namedObject = new NamedObject((Object)new Double(d), 527);
                        this.object.push(namedObject);
                        namedObject = new NamedObject((Object)new Double(d2), 528);
                        this.object.push(namedObject);
                        break;
                    }
                    namedObject = new NamedObject((Object)new Integer(n4), 532);
                    this.object.push(namedObject);
                    namedObject = new NamedObject((Object)new Double(d), 529);
                    this.object.push(namedObject);
                    namedObject = new NamedObject((Object)new Double(d2), 530);
                    this.object.push(namedObject);
                    break;
                }
                case -256: {
                    this.errorAtLine("Unknown keyword!!");
                    break;
                }
                case 256: {
                    ++this.level;
                    this.build.push(this.object.pop());
                    this.object.push(new NamedObject(256));
                    break;
                }
                case 273: {
                    --this.level;
                    this.build((NamedObject)this.build.pop());
                    break;
                }
                default: {
                    this.object.push(new NamedObject(n));
                    break;
                }
            }
        }
        this.closeStream();
        if (this.graph == null) {
            return;
        }
        if (this.graph instanceof Graph2D) {
            ((Graph2D)this.graph).repaint();
        } else if (this.graph instanceof G2Dint) {
            ((G2Dint)this.graph).repaint();
        } else if (this.graph instanceof Contour) {
            ((Contour)this.graph).repaint();
        }
    }
}

