/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.G2Dint;
import graph.IsoCurve;
import graph.TextLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Vector;

public class Contour
extends G2Dint {
    MyKeyListener myKeyListener = new MyKeyListener();
    static final int MINCELLS = 30;
    static final int NLEVELS = 12;
    protected int nx = 0;
    protected int ny = 0;
    protected Vector[] curves = null;
    protected boolean autoLevels = true;
    protected boolean logLevels = false;
    protected boolean gridLimits = false;
    protected double[] levels = new double[12];
    protected TextLine[] labels = new TextLine[12];
    protected Font labelfont = new Font("Helvetica", 0, 12);
    protected Color labelcolor = Color.blue;
    protected int labelStyle = 2;
    protected int labelPrecision = 2;
    protected int labelSignificant = 3;
    protected int labelLevels = 1;
    protected boolean drawlabels = true;
    protected boolean autoLabels = true;
    protected Color contourColor = null;
    protected Color labelledColor = null;
    protected double[] grid = null;
    protected double xmin = 0.0;
    protected double xmax = 0.0;
    protected double ymin = 0.0;
    protected double ymax = 0.0;
    protected double zmin = 0.0;
    protected double zmax = 0.0;
    public boolean noContours = false;

    public void attachContours() {
        if (this.curves == null) {
            return;
        }
        this.attachCurves();
    }

    private void attachCurves() {
        if (this.curves == null) {
            return;
        }
        int n = 0;
        while (n < this.curves.length) {
            this.attachCurves(this.curves[n]);
            ++n;
        }
    }

    private void attachCurves(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            this.attachDataSet((DataSet)vector.elementAt(n));
            if (this.xaxis != null) {
                this.xaxis.attachDataSet((DataSet)vector.elementAt(n));
            }
            if (this.yaxis != null) {
                this.yaxis.attachDataSet((DataSet)vector.elementAt(n));
            }
            ++n;
        }
    }

    private void calcLabels() {
        if (!this.autoLabels) {
            return;
        }
        if (this.levels == null || this.levels.length <= 0) {
            return;
        }
        this.labels = new TextLine[this.levels.length];
        int n = 0;
        while (n < this.labels.length) {
            this.labels[n] = new TextLine();
            this.labels[n].parseDouble(this.levels[n], this.labelSignificant, this.labelPrecision, this.labelStyle);
            ++n;
        }
    }

    private void calcLevels() {
        if (!this.autoLevels) {
            return;
        }
        if (this.levels == null) {
            this.levels = new double[12];
        }
        this.labels = new TextLine[this.levels.length];
        if (this.logLevels) {
            double d = Math.log(this.zmax - this.zmin) / (double)(this.levels.length + 1);
            try {
                int n = 0;
                while (n < this.levels.length) {
                    this.levels[n] = this.zmin + Math.pow(Math.E, (double)(n + 1) * d);
                    ++n;
                }
            }
            catch (Exception exception) {
                this.logLevels = false;
                this.calcLevels();
            }
        } else {
            double d = (this.zmax - this.zmin) / (double)(this.levels.length + 1);
            int n = 0;
            while (n < this.levels.length) {
                this.levels[n] = this.zmin + (double)(n + 1) * d;
                ++n;
            }
        }
    }

    protected void calculateCurves() {
        double d = (this.xmax - this.xmin) / (double)(this.nx - 1);
        double d2 = (this.ymax - this.ymin) / (double)(this.ny - 1);
        IsoCurve isoCurve = new IsoCurve(this.grid, this.nx, this.ny);
        if (this.curves != null) {
            this.detachCurves();
            this.curves = null;
        }
        if (this.zmin == this.zmax) {
            return;
        }
        this.curves = new Vector[this.levels.length];
        int n = 0;
        while (n < this.levels.length) {
            double[] dArray;
            isoCurve.setValue(this.levels[n]);
            this.curves[n] = new Vector();
            while ((dArray = isoCurve.getCurve()) != null) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n2] = this.xmin + dArray[n2] * d;
                    dArray[++n2] = this.ymin + dArray[n2] * d2;
                    ++n2;
                }
                try {
                    this.curves[n].addElement(new DataSet(dArray, dArray.length / 2));
                }
                catch (Exception exception) {}
            }
            this.attachCurves(this.curves[n]);
            ++n;
        }
    }

    public void deleteContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
        this.curves = null;
    }

    public void detachContours() {
        if (this.curves == null) {
            return;
        }
        this.detachCurves();
    }

    private void detachCurves() {
        if (this.curves == null) {
            return;
        }
        int n = 0;
        while (n < this.curves.length) {
            this.detachCurves(this.curves[n]);
            ++n;
        }
    }

    private void detachCurves(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            this.detachDataSet((DataSet)vector.elementAt(n));
            if (this.xaxis != null) {
                this.xaxis.detachDataSet((DataSet)vector.elementAt(n));
            }
            if (this.yaxis != null) {
                this.yaxis.detachDataSet((DataSet)vector.elementAt(n));
            }
            ++n;
        }
    }

    public int[] getDim() {
        int[] nArray = new int[]{this.nx, this.ny};
        return nArray;
    }

    public double[] getGrid() {
        return this.grid;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public int getLabelSignificance() {
        return this.labelSignificant;
    }

    public int getLabelStyle() {
        return this.labelStyle;
    }

    public double[] getLevels() {
        return this.levels;
    }

    public double[] getRange() {
        double[] dArray = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        return dArray;
    }

    public boolean loadGrid(URL uRL) {
        return false;
    }

    public void paintFirst(Graphics graphics, Rectangle rectangle) {
        if (this.curves == null && !this.noContours) {
            this.calculateCurves();
            this.calcLabels();
        }
        this.setContourColors();
        if (this.gridLimits && !this.userlimits) {
            if (this.xaxis != null) {
                if (this.xaxis.minimum > this.xmin) {
                    this.xaxis.minimum = this.xmin;
                }
                if (this.xaxis.maximum < this.xmax) {
                    this.xaxis.maximum = this.xmax;
                }
            }
            if (this.yaxis != null) {
                if (this.yaxis.minimum > this.ymin) {
                    this.yaxis.minimum = this.ymin;
                }
                if (this.yaxis.maximum < this.ymax) {
                    this.yaxis.maximum = this.ymax;
                }
            }
        } else if (this.dataset.isEmpty()) {
            if (this.xaxis != null) {
                this.xaxis.minimum = this.xmin;
                this.xaxis.maximum = this.xmax;
            }
            if (this.yaxis != null) {
                this.yaxis.minimum = this.ymin;
                this.yaxis.maximum = this.ymax;
            }
        }
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        double[] dArray = new double[2];
        Color color = graphics.getColor();
        Rectangle rectangle2 = new Rectangle();
        if (this.xaxis == null || this.yaxis == null || this.labels == null || this.labelLevels == 0 || !this.drawlabels || this.curves == null) {
            super.paintLast(graphics, rectangle);
            return;
        }
        int n = 0;
        while (n < this.levels.length) {
            if (this.labels[n] != null && !this.labels[n].isNull() && n % this.labelLevels == 0) {
                this.labels[n].setFont(this.labelfont);
                this.labels[n].setColor(this.labelcolor);
                Vector vector = this.curves[n];
                int n2 = 0;
                while (n2 < vector.size()) {
                    DataSet dataSet = (DataSet)vector.elementAt(n2);
                    int n3 = dataSet.dataPoints();
                    int n4 = (int)(Math.random() * 30.0);
                    while (n3 > 30) {
                        dArray = dataSet.getPoint(n4);
                        int n5 = this.xaxis.getInteger(dArray[0]);
                        int n6 = this.yaxis.getInteger(dArray[1]);
                        rectangle2.width = this.labels[n].getWidth(graphics);
                        rectangle2.height = this.labels[n].getAscent(graphics);
                        rectangle2.x = n5 - rectangle2.width / 2;
                        rectangle2.y = n6 - rectangle2.height / 2;
                        graphics.setColor(this.DataBackground);
                        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics.setColor(color);
                        this.labels[n].draw(graphics, rectangle2.x, rectangle2.y + rectangle2.height, 1);
                        n3 -= 30;
                        n4 += 30;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        super.paintLast(graphics, rectangle);
    }

    public void setAutoLevels(boolean bl) {
        this.autoLevels = bl;
    }

    public void setContourColor(Color color) {
        this.contourColor = color;
    }

    private void setContourColors() {
        if (this.curves == null || this.contourColor == null && this.labelledColor == null) {
            return;
        }
        int n = 0;
        while (n < this.curves.length) {
            this.setContourColors(this.curves[n], null);
            ++n;
        }
        if (this.contourColor != null) {
            n = 0;
            while (n < this.curves.length) {
                this.setContourColors(this.curves[n], this.contourColor);
                ++n;
            }
        }
        if (this.labelledColor != null) {
            n = 0;
            while (n < this.curves.length) {
                if (n % this.labelLevels == 0) {
                    this.setContourColors(this.curves[n], this.labelledColor);
                }
                ++n;
            }
        }
    }

    private void setContourColors(Vector vector, Color color) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            DataSet dataSet = (DataSet)vector.elementAt(n);
            if (dataSet != null) {
                dataSet.linecolor = color;
            }
            ++n;
        }
    }

    public void setDrawLabels(boolean bl) {
        this.drawlabels = bl;
    }

    public void setGrid(double[] dArray, int n, int n2) {
        this.grid = dArray;
        this.nx = n;
        this.ny = n2;
        this.zrange();
        this.calcLevels();
    }

    public void setLabelColor(Color color) {
        this.labelcolor = color;
    }

    public void setLabelFont(Font font) {
        this.labelfont = font;
    }

    public void setLabelLevels(int n) {
        this.labelLevels = n <= 0 ? 0 : n;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
        this.calcLabels();
    }

    public void setLabelSignificance(int n) {
        this.labelSignificant = n;
        this.calcLabels();
    }

    public void setLabelStyle(int n) {
        this.labelStyle = n;
        this.calcLabels();
    }

    public void setLabelledContourColor(Color color) {
        this.labelledColor = color;
    }

    public void setLabels(TextLine[] textLineArray, int n) {
        if (textLineArray == null || n <= 0) {
            return;
        }
        this.autoLabels = false;
        this.labels = new TextLine[n];
        System.arraycopy(textLineArray, 0, this.labels, 0, n);
    }

    public void setLevels(double[] dArray, int n) {
        if (dArray == null || n <= 0) {
            return;
        }
        this.detachCurves();
        this.curves = null;
        this.autoLevels = false;
        this.levels = new double[n];
        System.arraycopy(dArray, 0, this.levels, 0, n);
        this.labels = new TextLine[n];
        int n2 = 0;
        while (n2 < this.labels.length) {
            this.labels[n2] = new TextLine(String.valueOf((float)dArray[n2]));
            ++n2;
        }
    }

    public void setLimitsToGrid(boolean bl) {
        this.gridLimits = bl;
    }

    public void setLogLevels(boolean bl) {
        this.logLevels = bl;
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    public void setNLevels(int n) {
        if (n <= 0) {
            return;
        }
        this.levels = new double[n];
        this.calcLevels();
        this.detachCurves();
        this.curves = null;
    }

    public void setRange(double d, double d2, double d3, double d4) {
        if (d >= d2 || d3 >= d4) {
            return;
        }
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    private void zrange() {
        this.zmin = this.grid[0];
        this.zmax = this.grid[1];
        int n = 0;
        while (n < this.grid.length) {
            this.zmin = Math.min(this.zmin, this.grid[n]);
            this.zmax = Math.max(this.zmax, this.grid[n]);
            ++n;
        }
        if (this.zmin <= 0.0 || this.zmax <= 0.0) {
            this.logLevels = false;
        }
    }

    public class MyKeyListener
    extends KeyAdapter
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            if (Contour.this.xaxis != null && Contour.this.yaxis != null) {
                switch (keyEvent.getKeyChar()) {
                    case 'l': {
                        Contour.this.drawlabels = false;
                        Contour.this.repaint();
                        break;
                    }
                    case 'L': {
                        Contour.this.drawlabels = true;
                        Contour.this.repaint();
                        break;
                    }
                }
            }
        }
    }
}

