/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Cell;
import java.util.Vector;

public class IsoCurve {
    static final int TERMINAL = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int TOP = 3;
    static final int BOTTOM = 4;
    static final int ARRAYSIZE = 100;
    static final int MAXARRAYSIZE = 2000;
    protected Vector cells = null;
    protected double[] grid = null;
    protected int nx = 0;
    protected int ny = 0;
    protected double[] curve = null;
    protected int size = 0;
    protected double value = 0.0;

    public IsoCurve() {
    }

    public IsoCurve(double[] dArray, int n, int n2) {
        this();
        this.setGrid(dArray, n, n2);
    }

    protected void addDataPoint(double d, double d2) {
        if (this.size >= 1998) {
            return;
        }
        if (this.curve == null) {
            this.curve = new double[100];
        } else if (this.size == this.curve.length - 2) {
            double[] dArray = new double[2 * this.size];
            System.arraycopy(this.curve, 0, dArray, 0, this.size);
            this.curve = dArray;
        }
        this.curve[this.size] = d;
        ++this.size;
        this.curve[this.size] = d2;
        ++this.size;
    }

    protected void addDataPoint(int n, int n2, int n3) {
        double[] dArray = this.getPoint(n, n2, n3);
        this.addDataPoint(dArray[0], dArray[1]);
    }

    protected void createCells() {
        if (this.cells == null) {
            this.cells = new Vector();
        } else {
            this.cells.removeAllElements();
        }
        int n = 0;
        while (n < this.ny - 1) {
            int n2 = n * this.nx;
            int n3 = 0;
            while (n3 < this.nx - 1) {
                Cell cell;
                int n4 = n3 + n2;
                double d = this.grid[n4];
                double d2 = this.grid[n4 + 1];
                double d3 = this.grid[n4 + this.nx];
                double d4 = this.grid[n4 + this.nx + 1];
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if ((d - this.value) * (d2 - this.value) <= 0.0) {
                    bl = true;
                }
                if ((d2 - this.value) * (d4 - this.value) <= 0.0) {
                    bl4 = true;
                }
                if ((d4 - this.value) * (d3 - this.value) <= 0.0) {
                    bl2 = true;
                }
                if ((d3 - this.value) * (d - this.value) <= 0.0) {
                    bl3 = true;
                }
                if (bl2 && bl && bl3 && bl4) {
                    if (d4 >= d3 && d >= d2) {
                        cell = new Cell();
                        cell.i = n3;
                        cell.j = n;
                        cell.face[0] = 3;
                        cell.face[1] = 1;
                        this.cells.addElement(cell);
                        cell = new Cell();
                        cell.i = n3;
                        cell.j = n;
                        cell.face[0] = 4;
                        cell.face[1] = 2;
                        this.cells.addElement(cell);
                    } else if (d3 >= d4 && d2 >= d) {
                        cell = new Cell();
                        cell.i = n3;
                        cell.j = n;
                        cell.face[0] = 3;
                        cell.face[1] = 1;
                        this.cells.addElement(cell);
                        cell = new Cell();
                        cell.i = n3;
                        cell.j = n;
                        cell.face[0] = 4;
                        cell.face[1] = 2;
                    }
                } else if (bl2 || bl || bl3 || bl4) {
                    cell = new Cell();
                    this.cells.addElement(cell);
                    cell.i = n3;
                    cell.j = n;
                    if (d == this.value && d2 == this.value) {
                        bl = false;
                    }
                    if (d == this.value && d3 == this.value) {
                        bl3 = false;
                    }
                    if (d4 == this.value && d3 == this.value) {
                        bl2 = false;
                    }
                    if (d4 == this.value && d2 == this.value) {
                        bl4 = false;
                    }
                    int n5 = 0;
                    if (bl) {
                        ++n5;
                    }
                    if (bl2) {
                        ++n5;
                    }
                    if (bl3) {
                        ++n5;
                    }
                    if (bl4) {
                        ++n5;
                    }
                    if (n5 <= 2) {
                        n5 = 0;
                        if (bl) {
                            cell.face[n5] = 4;
                            ++n5;
                        }
                        if (bl2) {
                            cell.face[n5] = 3;
                            ++n5;
                        }
                        if (bl3) {
                            cell.face[n5] = 1;
                            ++n5;
                        }
                        if (bl4) {
                            cell.face[n5] = 2;
                            ++n5;
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public double[] getCurve() {
        this.size = 0;
        this.getcurve();
        if (this.size == 0 || this.curve == null) {
            return null;
        }
        double[] dArray = new double[this.size];
        System.arraycopy(this.curve, 0, dArray, 0, this.size);
        return dArray;
    }

    protected double[] getPoint(int n, int n2, int n3) {
        double[] dArray = new double[2];
        int n4 = n2 + n3 * this.nx;
        if (n == 3) {
            double d = this.grid[n4 + this.nx];
            double d2 = this.grid[n4 + this.nx + 1];
            dArray[1] = n3 + 1;
            dArray[0] = (double)n2 + (this.value - d) / (d2 - d);
        } else if (n == 4) {
            double d = this.grid[n4];
            double d3 = this.grid[n4 + 1];
            dArray[1] = n3;
            dArray[0] = (double)n2 + (this.value - d) / (d3 - d);
        } else if (n == 1) {
            double d = this.grid[n4];
            double d4 = this.grid[n4 + this.nx];
            dArray[1] = (double)n3 + (this.value - d) / (d4 - d);
            dArray[0] = n2;
        } else if (n == 2) {
            double d = this.grid[n4 + 1];
            double d5 = this.grid[n4 + 1 + this.nx];
            dArray[1] = (double)n3 + (this.value - d) / (d5 - d);
            dArray[0] = n2 + 1;
        }
        return dArray;
    }

    protected void getcurve() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        double[] dArray = new double[2];
        this.size = 0;
        if (this.cells == null || this.cells.isEmpty()) {
            return;
        }
        Cell cell = (Cell)this.cells.firstElement();
        if (cell.face[0] == 0 && cell.face[1] == 0) {
            this.cells.removeElement(cell);
            return;
        }
        int n4 = cell.i;
        int n5 = cell.j;
        n2 = -1;
        n3 = -1;
        if (this.search(n4 - 1, n5) == null && (cell.face[0] == 1 || cell.face[1] == 1)) {
            this.addDataPoint(1, n4, n5);
            n = 1;
        } else if (this.search(n4 + 1, n5) == null && (cell.face[0] == 2 || cell.face[1] == 2)) {
            this.addDataPoint(2, n4, n5);
            n = 2;
        } else if (this.search(n4, n5 - this.nx) == null && (cell.face[0] == 4 || cell.face[1] == 4)) {
            this.addDataPoint(4, n4, n5);
            n = 4;
        } else if (this.search(n4, n5 + this.nx) == null && (cell.face[0] == 3 || cell.face[1] == 3)) {
            this.addDataPoint(3, n4, n5);
            n = 3;
        } else {
            int n6 = 0;
            if (cell.face[0] == 0) {
                n6 = 1;
            }
            this.addDataPoint(cell.face[n6], n4, n5);
            n = cell.face[n6];
            if (n == 3) {
                n2 = cell.i;
                n3 = cell.j + 1;
            } else if (n == 4) {
                n2 = cell.i;
                n3 = cell.j - 1;
            } else if (n == 1) {
                n2 = cell.i - 1;
                n3 = cell.j;
            } else if (n == 2) {
                n2 = cell.i + 1;
                n3 = cell.j;
            }
        }
        while (cell != null) {
            n4 = cell.i;
            n5 = cell.j;
            if ((n = cell.face[0] == n ? cell.face[1] : cell.face[0]) != 0) {
                this.addDataPoint(n, n4, n5);
            }
            if (n == 3) {
                ++n5;
                n = 4;
            } else if (n == 4) {
                --n5;
                n = 3;
            } else if (n == 1) {
                --n4;
                n = 2;
            } else if (n == 2) {
                ++n4;
                n = 1;
            }
            this.cells.removeElement(cell);
            if (n4 == n2 && n5 == n3) {
                this.addDataPoint(this.curve[0], this.curve[1]);
                cell = null;
                continue;
            }
            cell = this.search(n4, n5);
        }
    }

    protected Cell search(int n, int n2) {
        Cell cell = null;
        if (this.cells.isEmpty()) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.cells.size()) {
            cell = (Cell)this.cells.elementAt(n3);
            if (cell.i == n && cell.j == n2) {
                return cell;
            }
            ++n3;
        }
        return null;
    }

    public void setGrid(double[] dArray, int n, int n2) {
        this.grid = dArray;
        this.nx = n;
        this.ny = n2;
    }

    public void setValue(double d) {
        this.value = d;
        if (this.grid == null) {
            return;
        }
        this.createCells();
    }
}

