/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.Graph2D;
import graph.Markers;
import graph.TextLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DataSet {
    public static final int NOLINE = 0;
    public static final int LINE = 1;
    public Graph2D g2d;
    public int linestyle = 1;
    public Color linecolor = null;
    public int[] scaledpoints;
    public int marker = 0;
    public Color markercolor = null;
    public double markerscale = 1.0;
    public Axis xaxis;
    public Axis yaxis;
    public double xmax;
    public double xmin;
    public double ymax;
    public double ymin;
    public boolean clipping = true;
    public boolean animation = true;
    protected double dxmax;
    protected double dxmin;
    protected double dymax;
    protected double dymin;
    protected double[] data;
    protected int length;
    protected double xrange;
    protected double yrange;
    protected int legend_length = 20;
    protected TextLine legend_text = null;
    protected int legend_ix;
    protected int legend_iy;
    protected double legend_dx;
    protected double legend_dy;
    protected int increment = 100;
    protected int stride = 2;

    public DataSet() {
        this.length = 0;
        this.range(this.stride);
    }

    public DataSet(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        this.stride = n;
        this.length = 0;
        this.range(n);
    }

    public DataSet(double[] dArray, int n) throws Exception {
        boolean bl = false;
        this.length = 0;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        this.scaledpoints = new int[this.length];
        System.arraycopy(dArray, 0, this.data, 0, this.length);
        this.range(this.stride);
    }

    public DataSet(double[] dArray, int n, int n2) throws Exception {
        if (n2 < 2) {
            throw new Exception("Invalid stride parameter!");
        }
        boolean bl = false;
        this.length = 0;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in parsed data!");
        }
        this.stride = n2;
        this.data = new double[n * this.stride];
        this.length = n * this.stride;
        System.arraycopy(dArray, 0, this.data, 0, this.length);
        this.range(this.stride);
    }

    public void append(double[] dArray, int n) throws Exception {
        boolean bl = false;
        int n2 = n * this.stride;
        if (dArray == null || dArray.length == 0 || n <= 0) {
            throw new Exception("DataSet: Error in append data!");
        }
        if (this.data == null) {
            this.data = new double[this.increment];
        }
        if (n2 + this.length < this.data.length) {
            System.arraycopy(dArray, 0, this.data, this.length, n2);
            this.length += n2;
        } else {
            double[] dArray2 = new double[n2 + this.length + this.increment];
            if (this.length != 0) {
                System.arraycopy(this.data, 0, dArray2, 0, this.length);
            }
            System.arraycopy(dArray, 0, dArray2, this.length, n2);
            this.length += n2;
            this.data = dArray2;
        }
        this.range(this.stride);
    }

    protected boolean contains(double d, double d2) {
        return d >= this.xmin && d <= this.xmax && d2 >= this.ymin && d2 <= this.ymax;
    }

    public int dataPoints() {
        return this.length / this.stride;
    }

    public void delete(int n, int n2) {
        int n3 = this.stride * n2;
        int n4 = this.stride * n;
        if (this.length <= 0) {
            return;
        }
        if (n3 < n4) {
            return;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 > this.length - this.stride) {
            n3 = this.length - this.stride;
        }
        if (n3 < this.length - this.stride) {
            System.arraycopy(this.data, n3 + this.stride, this.data, n4, this.length - n3 - this.stride);
        }
        this.length -= n3 + this.stride - n4;
        this.range(this.stride);
    }

    public void deleteData() {
        this.length = 0;
        this.data = null;
        this.range(this.stride);
    }

    public void draw_data(Graphics graphics, Rectangle rectangle) {
        if (this.xaxis != null) {
            this.xmax = this.xaxis.maximum;
            this.xmin = this.xaxis.minimum;
        }
        if (this.yaxis != null) {
            this.ymax = this.yaxis.maximum;
            this.ymin = this.yaxis.minimum;
        }
        this.xrange = this.xmax - this.xmin;
        this.yrange = this.ymax - this.ymin;
        this.draw_legend(graphics, rectangle);
        if (this.clipping) {
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Color color = graphics.getColor();
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_lines(graphics, rectangle);
        }
        if (this.marker > 0) {
            if (this.markercolor != null) {
                graphics.setColor(this.markercolor);
            } else {
                graphics.setColor(color);
            }
            this.draw_markers(graphics, rectangle);
        }
        graphics.setColor(color);
    }

    protected void draw_legend(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        Markers markers = null;
        if (this.legend_text == null) {
            return;
        }
        if (this.legend_text.isNull()) {
            return;
        }
        if (this.legend_ix == 0 && this.legend_iy == 0) {
            this.legend_ix = (int)((double)rectangle.x + (this.legend_dx - this.xmin) / this.xrange * (double)rectangle.width);
            this.legend_iy = (int)((double)rectangle.y + (1.0 - (this.legend_dy - this.ymin) / this.yrange) * (double)rectangle.height);
        }
        if (this.linestyle != 0) {
            if (this.linecolor != null) {
                graphics.setColor(this.linecolor);
            }
            graphics.drawLine(this.legend_ix, this.legend_iy, this.legend_ix + this.legend_length, this.legend_iy);
        }
        if (this.marker > 0 && (markers = this.g2d.getMarkers()) != null) {
            if (this.markercolor != null) {
                graphics.setColor(this.markercolor);
            } else {
                graphics.setColor(color);
            }
            markers.draw(graphics, this.marker, 1.0, this.legend_ix + this.legend_length / 2, this.legend_iy);
        }
        this.legend_text.draw(graphics, this.legend_ix + this.legend_length + this.legend_text.charWidth(graphics, ' '), this.legend_iy + this.legend_text.getAscent(graphics) / 3);
        graphics.setColor(color);
    }

    protected void draw_lines(Graphics graphics, Rectangle rectangle) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Rectangle rectangle2 = graphics.getClipBounds();
        int n6 = rectangle2.x;
        int n7 = rectangle2.x + rectangle2.width;
        int n8 = rectangle2.y;
        int n9 = rectangle2.y + rectangle2.height;
        if (this.data == null || this.data.length < this.stride) {
            return;
        }
        bl = this.contains(this.data[0], this.data[1]);
        if (bl) {
            n = (int)((double)rectangle.x + (this.data[0] - this.xmin) / this.xrange * (double)rectangle.width);
            n2 = (int)((double)rectangle.y + (1.0 - (this.data[1] - this.ymin) / this.yrange) * (double)rectangle.height);
            if (n < n6 || n > n7 || n2 < n8 || n2 > n9) {
                bl = false;
            }
        }
        int n10 = this.stride;
        while (n10 < this.length) {
            bl2 = this.contains(this.data[n10], this.data[n10 + 1]);
            if (bl2 || bl) {
                n3 = (int)((double)rectangle.x + (this.data[n10] - this.xmin) / this.xrange * (double)rectangle.width);
                n4 = (int)((double)rectangle.y + (1.0 - (this.data[n10 + 1] - this.ymin) / this.yrange) * (double)rectangle.height);
                if (n3 < n6 || n3 > n7 || n4 < n8 || n4 > n9) {
                    bl2 = false;
                }
            }
            if (!bl && bl2) {
                n = (int)((double)rectangle.x + (this.data[n10 - this.stride] - this.xmin) / this.xrange * (double)rectangle.width);
                n2 = (int)((double)rectangle.y + (1.0 - (this.data[n10 - this.stride + 1] - this.ymin) / this.yrange) * (double)rectangle.height);
            }
            if (bl || bl2) {
                if (this.animation) {
                    graphics.drawLine(n, n2, n3, n4);
                }
                if (bl) {
                    this.scaledpoints[n5++] = n;
                    this.scaledpoints[n5++] = n2;
                }
            }
            bl = bl2;
            n = n3;
            n2 = n4;
            n10 += this.stride;
        }
    }

    protected void draw_markers(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.x + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        Markers markers = this.g2d.getMarkers();
        if (markers == null) {
            return;
        }
        int n5 = 0;
        while (n5 < this.length) {
            if (this.contains(this.data[n5], this.data[n5 + 1])) {
                int n6 = (int)((double)rectangle.x + (this.data[n5] - this.xmin) / this.xrange * (double)rectangle.width);
                int n7 = (int)((double)rectangle.y + (1.0 - (this.data[n5 + 1] - this.ymin) / this.yrange) * (double)rectangle.height);
                if (n6 >= n && n6 <= n2 && n7 >= n3 && n7 <= n4) {
                    markers.draw(graphics, this.marker, this.markerscale, n6, n7);
                }
            }
            n5 += this.stride;
        }
    }

    public double[] getClosestPoint(double d, double d2) {
        double[] dArray = new double[3];
        double d3 = this.data[0] - d;
        double d4 = this.data[1] - d2;
        dArray[0] = this.data[0];
        dArray[1] = this.data[1];
        dArray[2] = d3 * d3 + d4 * d4;
        int n = this.stride;
        while (n < this.length - 1) {
            d3 = this.data[n] - d;
            d4 = this.data[n + 1] - d2;
            double d5 = d3 * d3 + d4 * d4;
            if (d5 < dArray[2]) {
                dArray[0] = this.data[n];
                dArray[1] = this.data[n + 1];
                dArray[2] = d5;
            }
            n += this.stride;
        }
        return dArray;
    }

    public double[] getPoint(int n) {
        double[] dArray = new double[this.stride];
        int n2 = n * this.stride;
        if (n < 0 || n2 > this.length - this.stride) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.stride) {
            dArray[n3] = this.data[n2 + n3];
            ++n3;
        }
        return dArray;
    }

    public double getXmax() {
        return this.dxmax;
    }

    public double getXmin() {
        return this.dxmin;
    }

    public double getYmax() {
        return this.dymax;
    }

    public double getYmin() {
        return this.dymin;
    }

    public void legend(double d, double d2, String string) {
        if (string == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(string);
        } else {
            this.legend_text.setText(string);
        }
        this.legend_text.setJustification(1);
        this.legend_dx = d;
        this.legend_dy = d2;
        this.legend_ix = 0;
        this.legend_iy = 0;
    }

    public void legend(int n, int n2, String string) {
        if (string == null) {
            this.legend_text = null;
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine(string);
        } else {
            this.legend_text.setText(string);
        }
        this.legend_text.setJustification(1);
        this.legend_ix = n;
        this.legend_iy = n2;
        this.legend_dx = 0.0;
        this.legend_dy = 0.0;
    }

    public void legendColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setColor(color);
    }

    public void legendFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.legend_text == null) {
            this.legend_text = new TextLine();
        }
        this.legend_text.setFont(font);
    }

    protected void range(int n) {
        if (this.length >= n) {
            this.dxmax = this.data[0];
            this.dymax = this.data[1];
            this.dxmin = this.dxmax;
            this.dymin = this.dymax;
        } else {
            this.dxmin = 0.0;
            this.dxmax = 0.0;
            this.dymin = 0.0;
            this.dymax = 0.0;
        }
        int n2 = n;
        while (n2 < this.length) {
            if (this.dxmax < this.data[n2]) {
                this.dxmax = this.data[n2];
            } else if (this.dxmin > this.data[n2]) {
                this.dxmin = this.data[n2];
            }
            if (this.dymax < this.data[n2 + 1]) {
                this.dymax = this.data[n2 + 1];
            } else if (this.dymin > this.data[n2 + 1]) {
                this.dymin = this.data[n2 + 1];
            }
            n2 += n;
        }
        if (this.xaxis == null) {
            this.xmin = this.dxmin;
            this.xmax = this.dxmax;
        }
        if (this.yaxis == null) {
            this.ymin = this.dymin;
            this.ymax = this.dymax;
        }
    }
}

