/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.DataSet;
import graph.Gin;
import graph.Graph2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class G2Dint
extends Graph2D {
    protected double xratio = 0.0;
    protected double yratio = 0.0;
    protected double xentry = 0.0;
    protected double yentry = 0.0;
    public double prevmin = 0.0;
    public double prevmax = 0.0;
    protected boolean drag = false;
    protected boolean newData = false;
    protected int maxlength = 0;
    protected boolean userlimits = false;
    private Gin cpgin = null;
    private Gin dpgin = null;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    private int x1old;
    private int y1old;
    public Axis xaxis;
    public Axis yaxis;
    MyMouseListener myMouseListener = new MyMouseListener();
    MyKeyListener myKeyListener = new MyKeyListener();
    Graph2D graph2d = this;
    public double temp_min;
    public double temp_max;

    static /* synthetic */ int access$4(G2Dint g2Dint) {
        return g2Dint.x1old;
    }

    static /* synthetic */ int access$6(G2Dint g2Dint) {
        return g2Dint.y1old;
    }

    public void attachAxis(Axis axis) {
        if (axis == null) {
            return;
        }
        super.attachAxis(axis);
        if (axis.getAxisPos() == 5 || axis.getAxisPos() == 4) {
            this.xaxis = axis;
        } else {
            this.yaxis = axis;
        }
    }

    public Axis createXAxis() {
        this.xaxis = super.createAxis(5);
        this.addMouseListener(this.myMouseListener);
        this.addMouseMotionListener(this.myMouseListener);
        this.addKeyListener(this.myKeyListener);
        return this.xaxis;
    }

    public Axis createYAxis() {
        this.yaxis = super.createAxis(2);
        this.addMouseListener(this.myMouseListener);
        this.addMouseMotionListener(this.myMouseListener);
        this.addKeyListener(this.myKeyListener);
        return this.yaxis;
    }

    public void fillArray() {
        this.maxlength = (this.datarect.width + this.datarect.x) * 2;
        if (this.curveArray == null) {
            this.curveArray = new double[(this.datarect.width + this.datarect.x) * 2];
        }
        this.detachDataSets();
        double d = (double)(this.yA - this.yB) / (double)(this.xB - this.xA);
        double d2 = 1.0;
        this.xaxis.maximum = this.xaxis.getXMax();
        this.xaxis.minimum = this.xaxis.getXMin();
        this.xratio = (this.xaxis.maximum - this.xaxis.minimum) / (double)this.datarect.width;
        this.yratio = (this.yaxis.maximum - this.yaxis.minimum) / (double)this.datarect.height;
        this.xentry = 0.0;
        this.yentry = 0.0;
        int n = this.xA;
        while (n <= this.xB) {
            this.xentry = (double)(n - this.datarect.x) * this.xratio + this.xaxis.minimum;
            this.yentry = (double)this.yA - d * (double)(n - this.xA);
            this.yentry -= (double)this.datarect.y;
            this.yentry = this.yaxis.maximum - this.yentry * this.yratio;
            if (this.currindex * 2 + 1 < this.maxlength) {
                this.curveArray[this.currindex * 2] = this.xentry;
                this.curveArray[this.currindex * 2 + 1] = this.yentry;
                ++this.currindex;
            }
            ++n;
        }
        this.datasaved = false;
        DataSet dataSet = this.loadDataSet(this.curveArray, this.currindex);
        this.xaxis.attachDataSet(dataSet);
        this.yaxis.attachDataSet(dataSet);
        dataSet.linestyle = 1;
        dataSet.linecolor = Color.blue;
    }

    public int getArrayLength() {
        return this.curveArray.length;
    }

    protected double[] getClosestPoint(int n, int n2) {
        double[] dArray = new double[3];
        double d = -1.0;
        double[] dArray2 = new double[2];
        double d2 = this.xaxis.getDouble(n);
        double d3 = this.yaxis.getDouble(n2);
        int n3 = 0;
        while (n3 < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n3);
            dArray = dataSet.getClosestPoint(d2, d3);
            if (d < 0.0 || d > dArray[2]) {
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                d = dArray[2];
            }
            ++n3;
        }
        return dArray2;
    }

    public double[] getDataArray() {
        double[] dArray = new double[this.curveArray.length];
        int n = 0;
        while (n < this.curveArray.length) {
            dArray[n] = this.curveArray[n];
            ++n;
        }
        return dArray;
    }

    public int getNumPoints() {
        return this.currindex;
    }

    public void initCustom() {
        this.newData = true;
        this.currindex = 0;
        this.xA = 0;
        this.xB = 0;
        this.initialized = false;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        Color color = graphics.getColor();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.drag) {
            graphics.setColor(this.DataBackground);
            float[] fArray = Color.RGBtoHSB(this.DataBackground.getRed(), this.DataBackground.getGreen(), this.DataBackground.getBlue(), null);
            if ((double)fArray[2] < 0.5) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.black);
            }
            graphics.drawLine(this.x0, this.y0, this.x1, this.y0);
            graphics.drawLine(this.x1, this.y0, this.x1, this.y1);
            graphics.drawLine(this.x1, this.y1, this.x0, this.y1);
            graphics.drawLine(this.x0, this.y1, this.x0, this.y0);
            graphics.setColor(color);
            this.x1old = this.x1;
            this.y1old = this.y1;
            return;
        }
    }

    public class MyMouseListener
    extends MouseInputAdapter
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && G2Dint.this.custom && !G2Dint.this.initialized) {
                G2Dint.this.initialized = true;
                G2Dint.this.xB = G2Dint.this.datarect.x;
                G2Dint.this.yB = G2Dint.this.datarect.height / 2 + G2Dint.this.datarect.y;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && G2Dint.this.xaxis != null && G2Dint.this.yaxis != null) {
                G2Dint.this.x1 = mouseEvent.getX();
                G2Dint.this.y1 = mouseEvent.getY();
                if (G2Dint.this.drag) {
                    if (G2Dint.this.x1 < G2Dint.this.datarect.x) {
                        G2Dint.this.x1 = G2Dint.this.datarect.x;
                    } else if (G2Dint.this.x1 > G2Dint.this.datarect.x + G2Dint.this.datarect.width) {
                        G2Dint.this.x1 = G2Dint.this.datarect.x + G2Dint.this.datarect.width;
                    }
                    if (G2Dint.this.y1 < G2Dint.this.datarect.y) {
                        G2Dint.this.y1 = G2Dint.this.datarect.y;
                    } else if (G2Dint.this.y1 > G2Dint.this.datarect.y + G2Dint.this.datarect.height) {
                        G2Dint.this.y1 = G2Dint.this.datarect.y + G2Dint.this.datarect.height;
                    }
                }
                if (G2Dint.this.cpgin != null && G2Dint.this.cpgin.isVisible()) {
                    G2Dint.this.cpgin.setXlabel(G2Dint.this.xaxis.getDouble(G2Dint.this.x1));
                    G2Dint.this.cpgin.setYlabel(G2Dint.this.yaxis.getDouble(G2Dint.this.y1));
                }
                G2Dint.this.repaint();
                G2Dint.this.graph2d.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && G2Dint.this.custom && !G2Dint.this.initialized) {
                G2Dint.this.initialized = true;
                G2Dint.this.xB = G2Dint.this.datarect.x;
                G2Dint.this.yB = G2Dint.this.datarect.height / 2 + G2Dint.this.datarect.y;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && G2Dint.this.xaxis != null && G2Dint.this.yaxis != null) {
                G2Dint.this.x1 = mouseEvent.getX();
                G2Dint.this.y1 = mouseEvent.getY();
                if (G2Dint.this.cpgin != null && G2Dint.this.cpgin.isVisible()) {
                    G2Dint.this.cpgin.setXlabel(G2Dint.this.xaxis.getDouble(G2Dint.this.x1));
                    G2Dint.this.cpgin.setYlabel(G2Dint.this.yaxis.getDouble(G2Dint.this.y1));
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && G2Dint.this.custom) {
                if (!G2Dint.this.initialized) {
                    G2Dint.this.initialized = true;
                    G2Dint.this.xB = G2Dint.this.datarect.x;
                    G2Dint.this.yB = G2Dint.this.datarect.height / 2 + G2Dint.this.datarect.y;
                }
                G2Dint.this.xA = G2Dint.this.xB;
                G2Dint.this.yA = G2Dint.this.yB;
                G2Dint.this.datasaved = true;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && G2Dint.this.xaxis != null && G2Dint.this.yaxis != null) {
                G2Dint.this.x0 = mouseEvent.getX();
                G2Dint.this.y0 = mouseEvent.getY();
                G2Dint.this.drag = true;
                G2Dint.this.x1old = G2Dint.this.x0;
                G2Dint.this.y1old = G2Dint.this.y0;
                if (G2Dint.this.x0 < G2Dint.this.datarect.x) {
                    G2Dint.this.x0 = G2Dint.this.datarect.x;
                } else if (G2Dint.this.x0 > G2Dint.this.datarect.x + G2Dint.this.datarect.width) {
                    G2Dint.this.x0 = G2Dint.this.datarect.x + G2Dint.this.datarect.width;
                }
                if (G2Dint.this.y0 < G2Dint.this.datarect.y) {
                    G2Dint.this.y0 = G2Dint.this.datarect.y;
                } else if (G2Dint.this.y0 > G2Dint.this.datarect.y + G2Dint.this.datarect.height) {
                    G2Dint.this.y0 = G2Dint.this.datarect.y + G2Dint.this.datarect.height;
                }
                G2Dint.this.repaint();
                G2Dint.this.graph2d.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && G2Dint.this.custom) {
                if (!G2Dint.this.initialized) {
                    G2Dint.this.initialized = true;
                    G2Dint.this.xB = G2Dint.this.datarect.x;
                    G2Dint.this.yB = G2Dint.this.datarect.height / 2 + G2Dint.this.datarect.y;
                }
                G2Dint.this.xB = mouseEvent.getX() > G2Dint.this.xA ? mouseEvent.getX() : G2Dint.this.xA + 1;
                G2Dint.this.yB = mouseEvent.getY();
                if (G2Dint.this.datasaved) {
                    G2Dint.this.fillArray();
                }
                G2Dint.this.repaint();
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && G2Dint.this.xaxis != null && G2Dint.this.yaxis != null) {
                G2Dint.this.x1 = mouseEvent.getX();
                G2Dint.this.y1 = mouseEvent.getY();
                if (G2Dint.this.drag) {
                    G2Dint.this.userlimits = true;
                    if (G2Dint.this.x1 < G2Dint.this.datarect.x) {
                        G2Dint.this.x1 = G2Dint.this.datarect.x;
                    } else if (G2Dint.this.x1 > G2Dint.this.datarect.x + G2Dint.this.datarect.width) {
                        G2Dint.this.x1 = G2Dint.this.datarect.x + G2Dint.this.datarect.width;
                    }
                    if (G2Dint.this.y1 < G2Dint.this.datarect.y) {
                        G2Dint.this.y1 = G2Dint.this.datarect.y;
                    } else if (G2Dint.this.y1 > G2Dint.this.datarect.y + G2Dint.this.datarect.height) {
                        G2Dint.this.y1 = G2Dint.this.datarect.y + G2Dint.this.datarect.height;
                    }
                    if (Math.abs(G2Dint.this.x0 - G2Dint.this.x1) > 5 && Math.abs(G2Dint.this.y0 - G2Dint.this.y1) > 5) {
                        if (G2Dint.this.x0 < G2Dint.this.x1) {
                            G2Dint.this.temp_min = G2Dint.this.xaxis.getDouble(G2Dint.this.x0);
                            G2Dint.this.temp_max = G2Dint.this.xaxis.getDouble(G2Dint.this.x1);
                            G2Dint.this.xaxis.minimum = G2Dint.this.temp_min;
                            G2Dint.this.xaxis.maximum = G2Dint.this.temp_max;
                        } else {
                            G2Dint.this.temp_max = G2Dint.this.xaxis.getDouble(G2Dint.this.x0);
                            G2Dint.this.xaxis.minimum = G2Dint.this.temp_min = G2Dint.this.xaxis.getDouble(G2Dint.this.x1);
                            G2Dint.this.xaxis.maximum = G2Dint.this.temp_max;
                        }
                        if (G2Dint.this.y0 > G2Dint.this.y1) {
                            G2Dint.this.temp_min = G2Dint.this.yaxis.getDouble(G2Dint.this.y0);
                            G2Dint.this.temp_max = G2Dint.this.yaxis.getDouble(G2Dint.this.y1);
                            G2Dint.this.yaxis.minimum = G2Dint.this.temp_min;
                            G2Dint.this.yaxis.maximum = G2Dint.this.temp_max;
                        } else {
                            G2Dint.this.temp_max = G2Dint.this.yaxis.getDouble(G2Dint.this.y0);
                            G2Dint.this.yaxis.minimum = G2Dint.this.temp_min = G2Dint.this.yaxis.getDouble(G2Dint.this.y1);
                            G2Dint.this.yaxis.maximum = G2Dint.this.temp_max;
                        }
                        G2Dint.this.repaint();
                        G2Dint.this.graph2d.repaint();
                    }
                }
                G2Dint.this.drag = false;
            }
        }
    }

    public class MyKeyListener
    extends KeyAdapter
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            if (G2Dint.this.xaxis != null && G2Dint.this.yaxis != null) {
                switch (keyEvent.getKeyChar()) {
                    case 'R': {
                        G2Dint.this.userlimits = false;
                        G2Dint.this.repaint();
                        break;
                    }
                    case 'r': {
                        G2Dint.this.repaint();
                        break;
                    }
                    case 'c': {
                        if (G2Dint.this.cpgin == null) {
                            G2Dint.this.cpgin = new Gin("Position");
                        }
                        if (G2Dint.this.cpgin.isVisible()) {
                            ((Component)G2Dint.this.cpgin).setVisible(false);
                            break;
                        }
                        ((Component)G2Dint.this.cpgin).setVisible(true);
                        break;
                    }
                    case 'D': {
                        if (G2Dint.this.dpgin == null) break;
                        ((Component)G2Dint.this.dpgin).setVisible(false);
                        break;
                    }
                    case 'd': {
                        if (G2Dint.this.dpgin == null) {
                            G2Dint.this.dpgin = new Gin("Data Point");
                        }
                        double[] dArray = G2Dint.this.getClosestPoint(G2Dint.this.x0, G2Dint.this.y0);
                        G2Dint.this.dpgin.setXlabel(dArray[0]);
                        G2Dint.this.dpgin.setYlabel(dArray[1]);
                        int n = G2Dint.this.xaxis.getInteger(dArray[0]);
                        int n2 = G2Dint.this.yaxis.getInteger(dArray[1]);
                        if (n < G2Dint.this.datarect.x || n > G2Dint.this.datarect.x + G2Dint.this.datarect.width || n2 < G2Dint.this.datarect.y || n2 > G2Dint.this.datarect.y + G2Dint.this.datarect.height) break;
                        Graphics graphics = G2Dint.this.getGraphics();
                        graphics.fillOval(n - 4, n2 - 4, 8, 8);
                        break;
                    }
                }
            }
        }
    }
}

