/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Axis;
import graph.DataSet;
import graph.LoadMessage;
import graph.Markers;
import graph.TextLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JPanel;

public class Graph2D
extends JPanel {
    MyKeyListener myKeyListener = new MyKeyListener();
    private Color DefaultBackground = null;
    protected boolean custom = false;
    protected boolean initialized = false;
    protected boolean datasaved = false;
    protected int currindex = 0;
    protected int width = 0;
    protected int height = 0;
    protected int zeroX = 0;
    protected int zeroY = 0;
    protected int xA = 0;
    protected int yA = 0;
    protected int xB = 0;
    protected int yB = 0;
    protected Vector axis = new Vector(4);
    public double[] curveArray = null;
    public Vector dataset = new Vector(10);
    protected Markers markers = null;
    protected LoadMessage load_thread = null;
    protected Color DataBackground = null;
    public int loadingData = 0;
    public int borderTop = 20;
    public int borderBottom = 20;
    public int borderLeft = 20;
    public int borderRight = 20;
    public boolean frame = true;
    public Color framecolor;
    public boolean drawgrid = true;
    public Color gridcolor = Color.pink;
    public boolean drawzero = true;
    public Color zerocolor = Color.black;
    public Rectangle datarect = new Rectangle();
    public boolean clearAll = true;
    public boolean paintAll = true;
    public boolean square = false;
    public TextLine lastText = null;

    protected Rectangle ForceSquare(Graphics graphics, Rectangle rectangle) {
        double d;
        Axis axis;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return rectangle;
        }
        int n5 = 0;
        while (n5 < this.axis.size()) {
            axis = (Axis)this.axis.elementAt(n5);
            d = axis.maximum - axis.minimum;
            if (axis.isVertical()) {
                d3 = Math.max(d, d3);
            } else {
                d2 = Math.max(d, d2);
            }
            ++n5;
        }
        if (d2 <= 0.0 | d3 <= 0.0) {
            return rectangle;
        }
        d = d2 > d3 ? d2 : d3;
        int n6 = 0;
        while (n6 < this.axis.size()) {
            axis = (Axis)this.axis.elementAt(n6);
            axis.maximum = axis.minimum + d;
            ++n6;
        }
        Rectangle rectangle2 = this.getDataRectangle(graphics, rectangle);
        if (rectangle2.width > rectangle2.height) {
            n = (int)((double)n + (double)(rectangle2.width - rectangle2.height) / 2.0);
            n3 -= rectangle2.width - rectangle2.height;
        } else {
            n2 = (int)((double)n2 + (double)(rectangle2.height - rectangle2.width) / 2.0);
            n4 -= rectangle2.height - rectangle2.width;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void attachAxis(Axis axis) {
        if (axis == null) {
            return;
        }
        try {
            this.axis.addElement(axis);
            axis.g2d = this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void attachDataSet(DataSet dataSet) {
        if (dataSet != null) {
            this.dataset.addElement(dataSet);
            dataSet.g2d = this;
        }
    }

    public Axis createAxis(int n) {
        Axis axis;
        try {
            axis = new Axis(n);
            axis.g2d = this;
            this.axis.addElement(axis);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return axis;
    }

    public void detachAxes() {
        if (this.axis == null | this.axis.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.axis.size()) {
            ((Axis)this.axis.elementAt(n)).detachAll();
            ((Axis)this.axis.elementAt((int)n)).g2d = null;
            ++n;
        }
        this.axis.removeAllElements();
    }

    public void detachAxis(Axis axis) {
        if (axis != null) {
            axis.detachAll();
            axis.g2d = null;
            this.axis.removeElement(axis);
        }
    }

    public void detachDataSet(DataSet dataSet) {
        if (dataSet != null) {
            if (dataSet.xaxis != null) {
                dataSet.xaxis.detachDataSet(dataSet);
            }
            if (dataSet.yaxis != null) {
                dataSet.yaxis.detachDataSet(dataSet);
            }
            this.dataset.removeElement(dataSet);
        }
    }

    public void detachDataSets() {
        if (this.dataset == null | this.dataset.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n);
            if (dataSet.xaxis != null) {
                dataSet.xaxis.detachDataSet(dataSet);
            }
            if (dataSet.yaxis != null) {
                dataSet.yaxis.detachDataSet(dataSet);
            }
            ++n;
        }
        this.dataset.removeAllElements();
    }

    protected Rectangle drawAxis(Graphics graphics, Rectangle rectangle) {
        if (this.square) {
            rectangle = this.ForceSquare(graphics, rectangle);
        }
        Rectangle rectangle2 = this.getDataRectangle(graphics, rectangle);
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        if (this.clearAll) {
            Color color = graphics.getColor();
            graphics.setColor(this.DataBackground);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(color);
        }
        if (this.frame) {
            this.drawFrame(graphics, n, n2, n3, n4);
        }
        int n5 = 0;
        while (n5 < this.axis.size()) {
            Axis axis = (Axis)this.axis.elementAt(n5);
            axis.data_window = new Dimension(n3, n4);
            switch (axis.getAxisPos()) {
                case 2: {
                    rectangle.x += axis.width;
                    rectangle.width -= axis.width;
                    axis.positionAxis(rectangle.x, rectangle.x, n2, n2 + n4);
                    if (rectangle.x == n) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    break;
                }
                case 3: {
                    rectangle.width -= axis.width;
                    axis.positionAxis(rectangle.x + rectangle.width, rectangle.x + rectangle.width, n2, n2 + n4);
                    if (rectangle.x + rectangle.width == n + n3) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    break;
                }
                case 4: {
                    rectangle.y += axis.width;
                    rectangle.height -= axis.width;
                    axis.positionAxis(n, n + n3, rectangle.y, rectangle.y);
                    if (rectangle.y == n2) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    break;
                }
                case 5: {
                    rectangle.height -= axis.width;
                    axis.positionAxis(n, n + n3, rectangle.y + rectangle.height, rectangle.y + rectangle.height);
                    if (rectangle.y + rectangle.height == n2 + n4) {
                        axis.gridcolor = this.gridcolor;
                        axis.drawgrid = this.drawgrid;
                        axis.zerocolor = this.zerocolor;
                        axis.drawzero = this.drawzero;
                    }
                    axis.drawAxis(graphics);
                    axis.drawgrid = false;
                    axis.drawzero = false;
                    break;
                }
            }
            ++n5;
        }
        return rectangle;
    }

    protected void drawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        if (this.framecolor != null) {
            graphics.setColor(this.framecolor);
        }
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(color);
    }

    public void finishedloading() {
        --this.loadingData;
        if (this.loadingData > 0) {
            return;
        }
        if (this.load_thread != null) {
            this.load_thread.end();
        }
        this.load_thread = null;
    }

    protected Rectangle getDataRectangle(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = 0;
        while (n5 < this.axis.size()) {
            Axis axis = (Axis)this.axis.elementAt(n5);
            int n6 = axis.getAxisWidth(graphics);
            switch (axis.getAxisPos()) {
                case 2: {
                    n += n6;
                    n3 -= n6;
                    break;
                }
                case 3: {
                    n3 -= n6;
                    break;
                }
                case 4: {
                    n2 += n6;
                    n4 -= n6;
                    break;
                }
                case 5: {
                    n4 -= n6;
                    break;
                }
            }
            ++n5;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public double getXmax() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        int n = 0;
        while (n < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n);
            d = n == 0 ? dataSet.getXmax() : Math.max(d, dataSet.getXmax());
            ++n;
        }
        return d;
    }

    public double getXmin() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        int n = 0;
        while (n < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n);
            d = n == 0 ? dataSet.getXmin() : Math.min(d, dataSet.getXmin());
            ++n;
        }
        return d;
    }

    public double getYmax() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        int n = 0;
        while (n < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n);
            d = n == 0 ? dataSet.getYmax() : Math.max(d, dataSet.getYmax());
            ++n;
        }
        return d;
    }

    public double getYmin() {
        double d = 0.0;
        if (this.dataset == null | this.dataset.isEmpty()) {
            return d;
        }
        int n = 0;
        while (n < this.dataset.size()) {
            DataSet dataSet = (DataSet)this.dataset.elementAt(n);
            d = n == 0 ? dataSet.getYmin() : Math.min(d, dataSet.getYmin());
            ++n;
        }
        return d;
    }

    public DataSet loadDataSet(double[] dArray, int n) {
        DataSet dataSet;
        try {
            dataSet = new DataSet(dArray, n);
            this.dataset.addElement(dataSet);
            dataSet.g2d = this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return dataSet;
    }

    public boolean loadFile(URL uRL) {
        return false;
    }

    public void loadmessage(String string) {
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setMessage(string);
    }

    public void paintBeforeData(Graphics graphics, Rectangle rectangle) {
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (this.DefaultBackground == null) {
            this.DefaultBackground = this.getBackground();
        }
        if (this.DataBackground == null) {
            this.DataBackground = this.getBackground();
        }
        if (!this.paintAll) {
            return;
        }
        rectangle.x += this.borderLeft;
        rectangle.y += this.borderTop;
        rectangle.width -= this.borderLeft + this.borderRight;
        rectangle.height -= this.borderBottom + this.borderTop;
        this.paintFirst(graphics2, rectangle);
        if (!this.axis.isEmpty()) {
            rectangle = this.drawAxis(graphics2, rectangle);
        } else {
            if (this.clearAll) {
                Color color = graphics.getColor();
                graphics.setColor(this.DataBackground);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(color);
            }
            this.drawFrame(graphics2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.paintBeforeData(graphics2, rectangle);
        if (!this.dataset.isEmpty()) {
            this.datarect.x = rectangle.x;
            this.datarect.y = rectangle.y;
            this.datarect.width = rectangle.width;
            this.datarect.height = rectangle.height;
            int n = 0;
            while (n < this.dataset.size()) {
                ((DataSet)this.dataset.elementAt(n)).draw_data(graphics2, rectangle);
                ++n;
            }
        }
        this.paintLast(graphics2, rectangle);
        graphics2.dispose();
    }

    public void paintFirst(Graphics graphics, Rectangle rectangle) {
    }

    public void paintLast(Graphics graphics, Rectangle rectangle) {
        if (this.lastText != null) {
            this.lastText.draw(graphics, rectangle.width / 2, rectangle.height / 2, 0);
        }
    }

    public void setDataBackground(Color color) {
        if (color == null) {
            return;
        }
        this.DataBackground = color;
    }

    public void setGraphBackground(Color color) {
        if (color == null) {
            return;
        }
        this.setBackground(color);
    }

    public void setMarkers(Markers markers) {
        this.markers = markers;
    }

    public void startedloading() {
        ++this.loadingData;
        if (this.loadingData != 1) {
            return;
        }
        if (this.load_thread == null) {
            this.load_thread = new LoadMessage(this);
        }
        this.load_thread.setFont(new Font("Helvetica", 0, 25));
        this.load_thread.begin();
    }

    public void update(Graphics graphics) {
        if (this.clearAll) {
            Color color = graphics.getColor();
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        if (this.paintAll) {
            this.paintComponent(graphics);
        }
    }

    public class MyKeyListener
    extends KeyAdapter
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case 'r': {
                    Graph2D.this.repaint();
                    break;
                }
            }
        }
    }
}

