/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.Graph2D;
import java.applet.Applet;
import java.net.URL;

public class LoadData
extends Thread {
    public final int NUMERIC = 1;
    public final int OBJECT = 2;
    private Graph2D graph = null;
    private Applet applet = null;
    private URL file;
    private int Max = 250;
    private DataSet ds = null;
    private double[] array = null;
    private boolean finished = false;
    private boolean started = false;
    private int count = 0;
    private int dataType = 1;

    public LoadData() {
        this.finished = false;
        this.started = false;
    }

    public LoadData(DataSet dataSet) {
        this.ds = dataSet;
        this.finished = false;
        this.started = false;
    }

    private synchronized void append(double[] dArray, int n) {
        if (n == 0) {
            return;
        }
        this.count += n;
        if (this.ds != null) {
            try {
                this.ds.append(dArray, n / 2);
            }
            catch (Exception exception) {
                this.printmessage("Failed to append data to DataSet!");
            }
        } else if (this.array != null) {
            double[] dArray2 = new double[this.array.length + n];
            System.arraycopy(this.array, 0, dArray2, 0, n);
            System.arraycopy(dArray, 0, dArray2, this.array.length, n);
            this.array = dArray2;
        } else {
            this.array = new double[n];
            System.arraycopy(dArray, 0, this.array, 0, n);
        }
    }

    public boolean finished() {
        return this.finished;
    }

    public synchronized double[] getArray() {
        if (this.array == null || this.array.length == 0) {
            return null;
        }
        if (this.finished) {
            return this.array;
        }
        if (this.started) {
            double[] dArray = new double[this.array.length];
            System.arraycopy(this.array, 0, dArray, 0, this.array.length);
            return dArray;
        }
        return null;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public int length() {
        return this.count;
    }

    public void loadArray(URL uRL) {
        if (uRL == null) {
            return;
        }
        this.file = uRL;
        this.start();
    }

    public void loadArray(URL uRL, Object object) {
        if (uRL == null) {
            return;
        }
        this.file = uRL;
        if (object != null) {
            if (object instanceof Applet) {
                this.applet = (Applet)object;
            } else if (object instanceof Graph2D) {
                this.graph = (Graph2D)object;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
    }

    public DataSet loadDataSet(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = uRL;
        this.start();
        return this.ds;
    }

    public DataSet loadDataSet(URL uRL, Object object) {
        if (uRL == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = uRL;
        if (object != null) {
            if (object instanceof Applet) {
                this.applet = (Applet)object;
            } else if (object instanceof Graph2D) {
                this.graph = (Graph2D)object;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
        return this.ds;
    }

    private void printmessage(String string) {
        if (string == null) {
            return;
        }
        if (this.applet != null) {
            this.applet.showStatus(string);
        }
    }

    public void run() {
        int n = 2 * this.Max;
        byte[] byArray = new byte[50];
        boolean bl = false;
        double[] dArray = new double[n];
        boolean bl2 = false;
        Object var6_6 = null;
        boolean bl3 = false;
        this.setPriority(1);
        this.started = false;
        this.finished = true;
        if (this.graph != null) {
            this.graph.finishedloading();
        }
        if (this.count == 0) {
            this.printmessage("Zero data loaded!");
            return;
        }
    }

    public boolean started() {
        return this.started;
    }
}

