/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Node;
import graph.ScanString;
import graph.SpecialFunction;

public class ParseFunction
extends ScanString {
    static final int GROUP = 1;
    static final int ENDGROUP = 2;
    static final int ADD = 3;
    static final int SUBTRACT = 4;
    static final int DIVIDE = 5;
    static final int MULTIPLY = 6;
    static final int LOG = 7;
    static final int POWER = 8;
    static final int PI = 9;
    static final int E = 10;
    static final int SIN = 11;
    static final int COS = 12;
    static final int TAN = 13;
    static final int X = 14;
    static final int Y = 15;
    static final int Z = 16;
    static final int ASIN = 17;
    static final int ACOS = 18;
    static final int ATAN = 19;
    static final int RAD = 20;
    static final int SQRT = 21;
    static final int RANDOM = 22;
    static final int LOG10 = 23;
    static final int EXP = 24;
    static final int REMAINDER = 25;
    static final int COMMA = 26;
    static final int ATAN2 = 27;
    static final int J0 = 28;
    static final int J1 = 29;
    static final int JN = 30;
    static final int SINH = 31;
    static final int COSH = 32;
    static final int TANH = 33;
    static final int ASINH = 34;
    static final int ACOSH = 35;
    static final int ATANH = 36;
    static final int Y0 = 37;
    static final int Y1 = 38;
    static final int YN = 39;
    static final int FAC = 40;
    static final int GAMMA = 41;
    static final int ERF = 42;
    static final int ERFC = 43;
    static final int NORMAL = 44;
    static final int POISSONC = 45;
    static final int POISSON = 46;
    static final int CHISQC = 47;
    static final int CHISQ = 48;
    static final int IGAM = 49;
    static final int IGAMC = 50;
    static final int BOLTZMAN = 101;
    static final int ECHARGE = 102;
    static final int EMASS = 103;
    static final int PMASS = 104;
    static final int GRAV = 105;
    static final int PLANCK = 106;
    static final int LIGHTSPEED = 107;
    static final int STEFANBOLTZ = 108;
    static final int AVOGADRO = 109;
    static final int GASCONSTANT = 110;
    static final int GRAVACC = 111;
    private Node root = null;
    private boolean independent_x = false;
    private boolean independent_y = false;
    private boolean independent_z = false;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    public boolean debug = false;

    public ParseFunction() {
        this.addKeyWord(",", 26);
        this.addKeyWord("(", 1);
        this.addKeyWord(")", 2);
        this.addKeyWord("+", 3);
        this.addKeyWord("-", 4);
        this.addKeyWord("/", 5);
        this.addKeyWord("*", 6);
        this.addKeyWord("log", 7);
        this.addKeyWord("^", 8);
        this.addKeyWord("pi", 9);
        this.addKeyWord("e", 10);
        this.addKeyWord("sin", 11);
        this.addKeyWord("cos", 12);
        this.addKeyWord("tan", 13);
        this.addKeyWord("x", 14);
        this.addKeyWord("y", 15);
        this.addKeyWord("z", 16);
        this.addKeyWord("asin", 17);
        this.addKeyWord("acos", 18);
        this.addKeyWord("atan", 19);
        this.addKeyWord("rad", 20);
        this.addKeyWord("sqrt", 21);
        this.addKeyWord("rand", 22);
        this.addKeyWord("log10", 23);
        this.addKeyWord("exp", 24);
        this.addKeyWord("rem", 25);
        this.addKeyWord("atan2", 27);
        this.addKeyWord("j0", 28);
        this.addKeyWord("j1", 29);
        this.addKeyWord("jn", 30);
        this.addKeyWord("sinh", 31);
        this.addKeyWord("cosh", 32);
        this.addKeyWord("tanh", 33);
        this.addKeyWord("asinh", 34);
        this.addKeyWord("acosh", 35);
        this.addKeyWord("atanh", 36);
        this.addKeyWord("y0", 37);
        this.addKeyWord("y1", 38);
        this.addKeyWord("yn", 39);
        this.addKeyWord("fac", 40);
        this.addKeyWord("gamma", 41);
        this.addKeyWord("erf", 42);
        this.addKeyWord("erfc", 43);
        this.addKeyWord("normal", 44);
        this.addKeyWord("poissonc", 45);
        this.addKeyWord("poisson", 46);
        this.addKeyWord("chisq", 48);
        this.addKeyWord("chisqc", 47);
        this.addKeyWord("igam", 49);
        this.addKeyWord("igamc", 50);
        this.addKeyWord("k", 101);
        this.addKeyWord("ec", 102);
        this.addKeyWord("me", 103);
        this.addKeyWord("mp", 104);
        this.addKeyWord("gc", 105);
        this.addKeyWord("h", 106);
        this.addKeyWord("c", 107);
        this.addKeyWord("sigma", 108);
        this.addKeyWord("na", 109);
        this.addKeyWord("r", 110);
        this.addKeyWord("g", 111);
    }

    public ParseFunction(String string) {
        this();
        this.setString(string);
    }

    private double evaluate(Node node) throws Exception {
        double d = 0.0;
        if (node == null) {
            throw new Exception("evaluate: Failed because of null node!");
        }
        switch (node.type) {
            case 5: {
                d = this.evaluate(node.left);
                break;
            }
            case 0: {
                d = this.evaluateOp(node);
                break;
            }
            case 2: {
                d = this.evaluateIntrinsic(node);
                break;
            }
            case 1: {
                d = node.value;
                break;
            }
            case 4: {
                if (node.op == 14) {
                    d = this.x;
                    break;
                }
                if (node.op == 15) {
                    d = this.y;
                    break;
                }
                if (node.op != 16) break;
                d = this.z;
                break;
            }
            default: {
                throw new Exception("evaluate: Unknown type!");
            }
        }
        return d;
    }

    private double evaluateIntrinsic(Node node) throws Exception {
        double d = 0.0;
        switch (node.op) {
            case 11: {
                d = Math.sin(this.evaluate(node.left));
                break;
            }
            case 12: {
                d = Math.cos(this.evaluate(node.left));
                break;
            }
            case 13: {
                d = Math.tan(this.evaluate(node.left));
                break;
            }
            case 17: {
                d = Math.asin(this.evaluate(node.left));
                break;
            }
            case 18: {
                d = Math.acos(this.evaluate(node.left));
                break;
            }
            case 19: {
                d = Math.atan(this.evaluate(node.left));
                break;
            }
            case 7: {
                d = Math.log(this.evaluate(node.left));
                break;
            }
            case 21: {
                d = Math.sqrt(this.evaluate(node.left));
                break;
            }
            case 23: {
                d = Math.log(this.evaluate(node.left)) / Math.E;
            }
            case 24: {
                d = Math.exp(this.evaluate(node.left));
                break;
            }
            case 28: {
                d = SpecialFunction.j0(this.evaluate(node.left));
                break;
            }
            case 29: {
                d = SpecialFunction.j1(this.evaluate(node.left));
                break;
            }
            case 37: {
                d = SpecialFunction.y0(this.evaluate(node.left));
                break;
            }
            case 38: {
                d = SpecialFunction.y1(this.evaluate(node.left));
                break;
            }
            case 40: {
                d = SpecialFunction.fac(this.evaluate(node.left));
                break;
            }
            case 41: {
                d = SpecialFunction.gamma(this.evaluate(node.left));
                break;
            }
            case 31: {
                d = SpecialFunction.sinh(this.evaluate(node.left));
                break;
            }
            case 32: {
                d = SpecialFunction.cosh(this.evaluate(node.left));
                break;
            }
            case 33: {
                d = SpecialFunction.tanh(this.evaluate(node.left));
                break;
            }
            case 34: {
                d = SpecialFunction.asinh(this.evaluate(node.left));
                break;
            }
            case 35: {
                d = SpecialFunction.acosh(this.evaluate(node.left));
                break;
            }
            case 36: {
                d = SpecialFunction.atanh(this.evaluate(node.left));
                break;
            }
            case 42: {
                d = SpecialFunction.erf(this.evaluate(node.left));
                break;
            }
            case 43: {
                d = SpecialFunction.erfc(this.evaluate(node.left));
                break;
            }
            case 44: {
                d = SpecialFunction.normal(this.evaluate(node.left));
                break;
            }
            case 46: {
                d = SpecialFunction.poisson((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 45: {
                d = SpecialFunction.poissonc((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 48: {
                d = SpecialFunction.chisq(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 47: {
                d = SpecialFunction.chisqc(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 49: {
                d = SpecialFunction.igam(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 50: {
                d = SpecialFunction.igamc(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 27: {
                d = Math.atan2(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            case 30: {
                d = SpecialFunction.jn((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            case 39: {
                d = SpecialFunction.yn((int)(this.evaluate(node.left) + 0.01), this.evaluate(node.right));
                break;
            }
            default: {
                throw new Exception("evaluate: Failed because of an unknown intrinsic!");
            }
        }
        return d;
    }

    private double evaluateOp(Node node) throws Exception {
        double d = 0.0;
        switch (node.op) {
            case 3: {
                if (node.left != null) {
                    d = this.evaluate(node.left);
                }
                d += this.evaluate(node.right);
                break;
            }
            case 4: {
                if (node.left != null) {
                    d = this.evaluate(node.left);
                }
                d -= this.evaluate(node.right);
                break;
            }
            case 5: {
                d = this.evaluate(node.left);
                d /= this.evaluate(node.right);
                break;
            }
            case 6: {
                d = this.evaluate(node.left);
                d *= this.evaluate(node.right);
                break;
            }
            case 8: {
                d = Math.pow(this.evaluate(node.left), this.evaluate(node.right));
                break;
            }
            default: {
                throw new Exception("evaluate: Failed because of Unknown operator!");
            }
        }
        return d;
    }

    public double getResult() throws Exception {
        return this.evaluate(this.root);
    }

    public double getResult(double d) throws Exception {
        this.x = d;
        return this.evaluate(this.root);
    }

    public double getResult(double d, double d2) throws Exception {
        this.x = d;
        this.y = d2;
        return this.evaluate(this.root);
    }

    public double getResult(double d, double d2, double d3) throws Exception {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this.evaluate(this.root);
    }

    public double[] getResults(int n, double[] dArray) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (dArray == null) {
            throw new Exception("X Array error");
        }
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.x = dArray[n2];
            dArray2[n2] = this.evaluate(this.root);
            ++n2;
        }
        return dArray2;
    }

    public double[] getResults(int n, double[] dArray, double[] dArray2) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (dArray == null) {
            throw new Exception("X Array error");
        }
        if (dArray2 == null) {
            throw new Exception("Y Array error");
        }
        double[] dArray3 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.x = dArray[n2];
            this.y = dArray2[n2];
            dArray3[n2] = this.evaluate(this.root);
            ++n2;
        }
        return dArray3;
    }

    public double[] getResults(int n, double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        if (n <= 0) {
            throw new Exception("Array index error");
        }
        if (dArray == null) {
            throw new Exception("X Array error");
        }
        if (dArray2 == null) {
            throw new Exception("Y Array error");
        }
        if (dArray3 == null) {
            throw new Exception("Z Array error");
        }
        double[] dArray4 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.x = dArray[n2];
            this.y = dArray2[n2];
            this.z = dArray3[n2];
            dArray4[n2] = this.evaluate(this.root);
            ++n2;
        }
        return dArray4;
    }

    public boolean[] getVariables() {
        boolean[] blArray = new boolean[]{this.independent_x, this.independent_y, this.independent_z};
        return blArray;
    }

    public boolean parse() {
        this.root = new Node();
        if (this.parseString(this.root) != -259) {
            return false;
        }
        if (this.debug) {
            this.root.print(5);
        }
        this.reOrderNodes(this.root);
        if (this.debug) {
            this.root.print(5);
        }
        return true;
    }

    public boolean parse(String string) {
        this.setString(string);
        return this.parse();
    }

    private int parseString(Node node) {
        int n = this.nextWord();
        if (n == -257) {
            return -257;
        }
        if (n == -259 || !this.debug) {
            boolean bl = n == -259 && this.debug;
        }
        switch (n) {
            case -258: {
                node.type = 1;
                node.value = this.nval;
                return this.parseString(node);
            }
            case 9: {
                node.type = 1;
                node.value = Math.PI;
                return this.parseString(node);
            }
            case 10: {
                node.type = 1;
                node.value = Math.E;
                return this.parseString(node);
            }
            case 101: {
                node.type = 1;
                node.value = 1.3807E-16;
                return this.parseString(node);
            }
            case 102: {
                node.type = 1;
                node.value = 4.8032E-10;
                return this.parseString(node);
            }
            case 103: {
                node.type = 1;
                node.value = 9.1095E-28;
                return this.parseString(node);
            }
            case 104: {
                node.type = 1;
                node.value = 1.6726E-24;
                return this.parseString(node);
            }
            case 105: {
                node.type = 1;
                node.value = 6.672E-8;
                return this.parseString(node);
            }
            case 106: {
                node.type = 1;
                node.value = 6.6262E-27;
                return this.parseString(node);
            }
            case 107: {
                node.type = 1;
                node.value = 2.9979E10;
                return this.parseString(node);
            }
            case 108: {
                node.type = 1;
                node.value = 5.6703E-5;
                return this.parseString(node);
            }
            case 109: {
                node.type = 1;
                node.value = 6.022E23;
                return this.parseString(node);
            }
            case 110: {
                node.type = 1;
                node.value = 8.3144E7;
                return this.parseString(node);
            }
            case 111: {
                node.type = 1;
                node.value = 980.67;
                return this.parseString(node);
            }
            case 20: {
                node.type = 1;
                node.value = Math.PI / 180;
                return this.parseString(node);
            }
            case 22: {
                node.type = 1;
                node.value = Math.random();
                return this.parseString(node);
            }
            case 14: 
            case 15: 
            case 16: {
                node.op = n;
                node.type = 4;
                if (n == 14) {
                    this.independent_x = true;
                } else if (n == 15) {
                    this.independent_y = true;
                } else if (n == 16) {
                    this.independent_z = true;
                }
                return this.parseString(node);
            }
            case 1: {
                Node node2 = new Node();
                if (this.parseString(node2) == 2) {
                    node.left = node2;
                    node.type = 5;
                    node.precedence = 5;
                    n = this.parseString(node);
                    break;
                }
                n = -257;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                Node node3 = new Node();
                int n2 = this.parseString(node3);
                if (n2 != -257) {
                    if ((n == 4 || n == 3) && node.type == 3) {
                        node.right = node3;
                        node.precedence = 4;
                        node.op = n;
                        node.type = 0;
                    } else {
                        Node node4;
                        node.left = node4 = new Node(node);
                        node.right = node3;
                        node.op = n;
                        node.type = 0;
                        switch (n) {
                            case 3: 
                            case 4: {
                                node.precedence = 1;
                                break;
                            }
                            case 5: 
                            case 6: {
                                node.precedence = 2;
                                break;
                            }
                            case 8: {
                                node.precedence = 3;
                                break;
                            }
                        }
                    }
                }
                n = n2;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                node.op = n;
                node.type = 2;
                node.precedence = 0;
                n = this.nextWord();
                if (n != 1) {
                    n = -257;
                    break;
                }
                Node node5 = new Node();
                if (this.parseString(node5) == 2) {
                    node.left = node5;
                    n = this.parseString(node);
                    break;
                }
                n = -257;
                break;
            }
            case 27: 
            case 30: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                node.op = n;
                node.type = 2;
                node.precedence = 0;
                n = this.nextWord();
                if (n != 1) {
                    n = -257;
                    break;
                }
                Node node6 = new Node();
                if (this.parseString(node6) == 26) {
                    Node node7 = new Node();
                    if (this.parseString(node7) == 2) {
                        node.right = node7;
                        node.left = node6;
                        n = this.parseString(node);
                        break;
                    }
                    n = -257;
                    break;
                }
                n = -257;
                break;
            }
        }
        return n;
    }

    private void reOrderNodes(Node node) {
        Node node2 = null;
        Node node3 = null;
        if (node == null) {
            return;
        }
        node2 = node.right;
        node3 = node.left;
        if (node2 != null && node2.type == 5) {
            this.reOrderNodes(node2);
        } else if (node3 != null && node3.type == 5) {
            this.reOrderNodes(node3);
        }
        if (node.type == 5) {
            this.reOrderNodes(node3);
        } else if (node.type == 0 && node2.type == 0 && node.precedence >= node2.precedence) {
            Node node4 = new Node(node);
            node4.right = node2.left;
            node.replace(node2);
            node.left = node4;
            node2 = null;
            this.reOrderNodes(node);
        }
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }
}

