/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.RotateTextFilter;
import graph.TextLine;
import graph.TextState;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import javax.swing.JComponent;

public class RTextLine
extends TextLine {
    protected int angle = 0;
    private double cos = 1.0;
    private double sin = 0.0;
    private JComponent component = null;

    public RTextLine() {
    }

    public RTextLine(Font font, Color color, int n) {
        super(font, color, n);
    }

    public RTextLine(Font font, Color color, int n, int n2) {
        super(font, color, n);
        this.setRotation(n2);
    }

    public RTextLine(String string) {
        super(string);
    }

    public RTextLine(String string, Color color) {
        super(string, color);
    }

    public RTextLine(String string, Font font) {
        super(string, font);
    }

    public RTextLine(String string, Font font, Color color, int n) {
        super(string, font, color, n);
    }

    public RTextLine(JComponent jComponent) {
        this.setDrawingComponent(jComponent);
    }

    public void copyState(RTextLine rTextLine) {
        if (rTextLine == null) {
            return;
        }
        this.font = rTextLine.getFont();
        this.color = rTextLine.getColor();
        this.justification = rTextLine.getJustification();
        this.setRotation(rTextLine.getRotation(), rTextLine.getComponent());
        if (this.font == null) {
            return;
        }
        this.fontname = this.font.getName();
        this.fontstyle = this.font.getStyle();
        this.fontsize = this.font.getSize();
        this.parse = true;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (graphics == null) {
            return;
        }
        if (this.component == null) {
            this.angle = 0;
        }
        if (this.angle == 0) {
            super.draw(graphics, n, n2);
        } else {
            this.draw(this.component, graphics, n, n2);
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.justification = n3;
        if (graphics == null) {
            return;
        }
        if (this.component == null) {
            this.angle = 0;
        }
        if (this.angle == 0) {
            super.draw(graphics, n, n2);
        } else {
            this.draw(this.component, graphics, n, n2);
        }
    }

    public synchronized void draw(JComponent jComponent, Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Image image = null;
        Graphics graphics2 = null;
        Image image2 = null;
        int n5 = 0;
        if (this.text == null || jComponent == null) {
            return;
        }
        this.parseText(graphics);
        n5 = this.maxAscent + this.maxDescent;
        switch (this.angle) {
            case -270: 
            case 90: {
                n3 = -this.maxAscent;
                if (this.justification == 0) {
                    n4 = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    n4 = 0;
                    break;
                }
                n4 = -this.width;
                break;
            }
            case -180: 
            case 180: {
                n4 = -this.maxDescent;
                if (this.justification == 0) {
                    n3 = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    n3 = 0;
                    break;
                }
                n3 = -this.width;
                break;
            }
            case -90: 
            case 270: {
                n3 = -this.maxDescent;
                if (this.justification == 0) {
                    n4 = -this.width / 2;
                    break;
                }
                if (this.justification == 2) {
                    n4 = -this.width;
                    break;
                }
                n4 = 0;
                break;
            }
            default: {
                n3 = 0;
                n4 = 0;
            }
        }
        image = jComponent.createImage(this.width, n5);
        graphics2 = image.getGraphics();
        if (this.background != null) {
            graphics2.setColor(this.background);
        } else {
            graphics2.setColor(jComponent.getBackground());
        }
        graphics2.fillRect(0, 0, this.width, n5);
        graphics2.setFont(graphics.getFont());
        graphics2.setColor(graphics.getColor());
        if (this.font != null) {
            graphics2.setFont(this.font);
        }
        if (this.color != null) {
            graphics2.setColor(this.color);
        }
        int n6 = 0;
        while (n6 < this.list.size()) {
            TextState textState = (TextState)this.list.elementAt(n6);
            if (textState.f != null) {
                graphics2.setFont(textState.f);
            }
            if (textState.s != null) {
                graphics2.drawString(textState.toString(), textState.x, textState.y + this.maxAscent);
            }
            ++n6;
        }
        RotateTextFilter rotateTextFilter = new RotateTextFilter(this.angle);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rotateTextFilter);
        image2 = jComponent.createImage(filteredImageSource);
        graphics.drawImage(image2, n + n3, n2 + n4, null);
    }

    public int getBottomEdge(Graphics graphics) {
        return this.getBottomEdge(graphics, this.justification);
    }

    public int getBottomEdge(Graphics graphics, int n) {
        this.parseText(graphics);
        switch (this.angle) {
            case -270: 
            case 90: {
                if (n == 0) {
                    return -this.width / 2;
                }
                if (n == 2) {
                    return -this.width;
                }
                return 0;
            }
            case -180: 
            case 180: {
                return -this.ascent;
            }
            case -90: 
            case 270: {
                if (n == 0) {
                    return -this.width / 2;
                }
                if (n == 2) {
                    return 0;
                }
                return -this.width;
            }
        }
        return -this.descent - this.leading;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int getLeftEdge(Graphics graphics) {
        return this.getLeftEdge(graphics, this.justification);
    }

    public int getLeftEdge(Graphics graphics, int n) {
        this.parseText(graphics);
        switch (this.angle) {
            case -270: 
            case 90: {
                return -this.ascent;
            }
            case -180: 
            case 180: {
                if (n == 0) {
                    return -this.width / 2;
                }
                if (n == 2) {
                    return 0;
                }
                return -this.width;
            }
            case -90: 
            case 270: {
                return -this.descent - this.leading;
            }
        }
        if (n == 0) {
            return -this.width / 2;
        }
        if (n == 2) {
            return -this.width;
        }
        return 0;
    }

    public int getRHeight(Graphics graphics) {
        this.parseText(graphics);
        return (int)(Math.abs(-this.sin * (double)this.width + this.cos * (double)this.height) + 0.5);
    }

    public int getRWidth(Graphics graphics) {
        this.parseText(graphics);
        return (int)(Math.abs(this.cos * (double)this.width + this.sin * (double)this.height) + 0.5);
    }

    public int getRightEdge(Graphics graphics) {
        return this.getRightEdge(graphics, this.justification);
    }

    public int getRightEdge(Graphics graphics, int n) {
        this.parseText(graphics);
        switch (this.angle) {
            case -270: 
            case 90: {
                return this.descent + this.leading;
            }
            case -180: 
            case 180: {
                if (n == 0) {
                    return this.width / 2;
                }
                if (n == 2) {
                    return this.width;
                }
                return 0;
            }
            case -90: 
            case 270: {
                return this.ascent;
            }
        }
        if (n == 0) {
            return this.width / 2;
        }
        if (n == 2) {
            return 0;
        }
        return this.width;
    }

    public int getRotation() {
        return this.angle;
    }

    public int getTopEdge(Graphics graphics) {
        return this.getTopEdge(graphics, this.justification);
    }

    public int getTopEdge(Graphics graphics, int n) {
        this.parseText(graphics);
        switch (this.angle) {
            case -270: 
            case 90: {
                if (n == 0) {
                    return this.width / 2;
                }
                if (n == 2) {
                    return 0;
                }
                return this.width;
            }
            case -180: 
            case 180: {
                return this.descent + this.leading;
            }
            case -90: 
            case 270: {
                if (n == 0) {
                    return this.width / 2;
                }
                if (n == 2) {
                    return this.width;
                }
                return 0;
            }
        }
        return this.ascent;
    }

    public void setDrawingComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public void setRotation(int n) {
        this.angle = n % 360 / 90 * 90;
        this.cos = Math.cos((double)n * Math.PI / 180.0);
        this.sin = Math.sin((double)n * Math.PI / 180.0);
    }

    public void setRotation(int n, JComponent jComponent) {
        this.setRotation(n);
        this.setDrawingComponent(jComponent);
    }
}

